/*
 * Decompiled with CFR 0.152.
 */
package de.itemis.xtext.utils.jface.viewers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import de.itemis.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import de.itemis.xtext.utils.jface.viewers.XtextSourceViewerEx;
import de.itemis.xtext.utils.jface.viewers.XtextStyledTextCellEditor;
import de.itemis.xtext.utils.jface.viewers.XtextStyledTextHighlightingHelper;
import de.itemis.xtext.utils.jface.viewers.context.IXtextFakeContextResourcesProvider;
import de.itemis.xtext.utils.jface.viewers.context.XtextFakeResourceContext;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class StyledTextXtextAdapter {
    protected XtextSourceViewer sourceviewer;
    private ValidationJob validationJob;
    private IssueResolutionProvider resolutionProvider = new IssueResolutionProvider.NullImpl();
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private ICharacterPairMatcher characterPairMatcher;
    @Inject
    private XtextSourceViewerConfiguration configuration;
    @Inject
    private XtextStyledTextHighlightingHelper xtextStyledTextHighlightingHelper;
    @Inject
    private IResourceValidator validator;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitioner;
    @Inject
    private XtextDocument document;
    private XtextFakeResourceContext fakeResourceContext;
    private final IXtextFakeContextResourcesProvider contextFakeResourceProvider;
    private StyledText styledText;
    private ControlDecoration decoration;

    public StyledTextXtextAdapter(Injector injector, IXtextFakeContextResourcesProvider contextFakeResourceProvider) {
        this.contextFakeResourceProvider = contextFakeResourceProvider;
        injector.injectMembers((Object)this);
        this.createFakeResourceContext(injector);
    }

    public StyledTextXtextAdapter(Injector injector) {
        this(injector, IXtextFakeContextResourcesProvider.NULL_CONTEXT_PROVIDER);
    }

    public void adapt(StyledText styledText) {
        this.styledText = styledText;
        this.updateFakeResourceContext();
        this.initXtextDocument(this.fakeResourceContext);
        this.createXtextSourceViewer();
        this.installHighlightingHelper();
        this.validationJob = this.createValidationJob();
        this.document.setValidationJob((Job)this.validationJob);
        styledText.setData(StyledTextXtextAdapter.class.getCanonicalName(), (Object)this);
        IContentAssistant contentAssistant = this.sourceviewer.getContentAssistant();
        final CompletionProposalAdapter completionProposalAdapter = new CompletionProposalAdapter((Control)styledText, contentAssistant, KeyStroke.getInstance((int)262144, (int)32), null);
        if ((styledText.getStyle() & 4) != 0) {
            styledText.addListener(3005, new Listener(){

                public void handleEvent(Event event) {
                    if (event.character == '\r' && !completionProposalAdapter.isProposalPopupOpen()) {
                        Event selectionEvent = new Event();
                        selectionEvent.type = 14;
                        selectionEvent.widget = event.widget;
                        Listener[] listenerArray = event.widget.getListeners(14);
                        int n = listenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Listener l = listenerArray[n2];
                            l.handleEvent(selectionEvent);
                            ++n2;
                        }
                    }
                }
            });
        }
        IFocusService service = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        service.addFocusTracker((Control)styledText, StyledText.class.getCanonicalName());
        this.createContentAssistDecoration(styledText);
    }

    protected void initSelectionProvider() {
        try {
            IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite();
            XtextStyledTextSelectionProvider xtextStyledTextSelectionProvider = new XtextStyledTextSelectionProvider();
            ChangeSelectionProviderOnFocusGain listener = new ChangeSelectionProviderOnFocusGain(site, xtextStyledTextSelectionProvider);
            this.styledText.addFocusListener((FocusListener)listener);
            this.styledText.addDisposeListener((DisposeListener)listener);
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void createContentAssistDecoration(StyledText styledText) {
        this.decoration = new ControlDecoration((Control)styledText, 16512);
        this.decoration.setShowHover(true);
        this.decoration.setShowOnlyOnFocus(true);
        final Image image = ImageDescriptor.createFromFile(XtextStyledTextCellEditor.class, (String)"images/content_assist_cue.gif").createImage();
        this.decoration.setImage(image);
        this.decoration.setDescriptionText("Content Assist Available (CTRL + Space)");
        this.decoration.setMarginWidth(2);
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StyledTextXtextAdapter.this.decoration != null) {
                    StyledTextXtextAdapter.this.decoration.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        });
    }

    protected ValidationJob createValidationJob() {
        return new ValidationJob(this.validator, (IReadAccess)this.document, (IValidationIssueProcessor)new AnnotationIssueProcessor((IXtextDocument)this.document, this.sourceviewer.getAnnotationModel(), this.resolutionProvider), CheckMode.ALL);
    }

    protected void createFakeResourceContext(Injector injector) {
        this.fakeResourceContext = new XtextFakeResourceContext(injector);
    }

    protected void createXtextSourceViewer() {
        this.sourceviewer = new XtextSourceViewerEx(this.styledText, this.preferenceStoreAccess.getPreferenceStore());
        this.sourceviewer.configure((SourceViewerConfiguration)this.configuration);
        this.sourceviewer.setDocument((IDocument)this.document, (IAnnotationModel)new AnnotationModel());
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport((ISourceViewer)this.sourceviewer, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedColors());
        this.configureSourceViewerDecorationSupport(support);
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        List prefs = annotationPreferences.getAnnotationPreferences();
        for (AnnotationPreference annotationPreference : prefs) {
            support.setAnnotationPreference(annotationPreference);
        }
        support.setCharacterPairMatcher(this.characterPairMatcher);
        support.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        support.install(this.preferenceStoreAccess.getPreferenceStore());
    }

    protected void initXtextDocument(XtextFakeResourceContext context) {
        this.document.setInput(context.getFakeResource());
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitioner.get();
        partitioner.connect((IDocument)this.document);
        this.document.setDocumentPartitioner(partitioner);
    }

    public void setVisibleRegion(int start, int length) {
        this.sourceviewer.setVisibleRegion(start, length);
    }

    public void resetVisibleRegion() {
        this.sourceviewer.resetVisibleRegion();
    }

    private void installHighlightingHelper() {
        if (this.xtextStyledTextHighlightingHelper != null) {
            this.xtextStyledTextHighlightingHelper.install(this, this.sourceviewer);
        }
    }

    private void uninstallHighlightingHelper() {
        if (this.xtextStyledTextHighlightingHelper != null) {
            this.xtextStyledTextHighlightingHelper.uninstall();
        }
    }

    public void dispose() {
        this.uninstallHighlightingHelper();
        this.document.disposeInput();
    }

    protected XtextSourceViewerConfiguration getXtextSourceViewerConfiguration() {
        return this.configuration;
    }

    protected XtextDocument getXtextDocument() {
        return this.document;
    }

    protected XtextSourceViewer getXtextSourceviewer() {
        return this.sourceviewer;
    }

    public IParseResult getXtextParseResult() {
        return (IParseResult)this.document.readOnly((IUnitOfWork)new IUnitOfWork<IParseResult, XtextResource>(){

            public IParseResult exec(XtextResource state) throws Exception {
                return state.getParseResult();
            }
        });
    }

    public IContentAssistant getContentAssistant() {
        return this.getXtextSourceviewer().getContentAssistant();
    }

    public List<Issue> getXtextValidationIssues() {
        return this.validationJob.createIssues((IProgressMonitor)new NullProgressMonitor());
    }

    public void updateFakeResourceContext() {
        this.fakeResourceContext.updateFakeResourceContext(this.contextFakeResourceProvider);
    }

    protected IXtextFakeContextResourcesProvider getFakeResourceContextProvider() {
        return this.contextFakeResourceProvider;
    }

    public XtextFakeResourceContext getFakeResourceContext() {
        return this.fakeResourceContext;
    }

    private class ChangeSelectionProviderOnFocusGain
    implements FocusListener,
    DisposeListener {
        private ISelectionProvider selectionProviderOnFocusGain;
        private ISelectionProvider selectionProviderOnFocusLost;
        private IWorkbenchPartSite site;

        public ChangeSelectionProviderOnFocusGain(IWorkbenchPartSite site, ISelectionProvider selectionProviderOnFocusGain) {
            this.selectionProviderOnFocusGain = selectionProviderOnFocusGain;
            this.site = site;
        }

        public void focusLost(FocusEvent e) {
            if (this.selectionProviderOnFocusLost != null) {
                this.site.setSelectionProvider(this.selectionProviderOnFocusLost);
            }
        }

        public void focusGained(FocusEvent e) {
            this.selectionProviderOnFocusLost = this.site.getSelectionProvider();
            this.site.setSelectionProvider(this.selectionProviderOnFocusGain);
        }

        public void widgetDisposed(DisposeEvent e) {
            ((StyledText)e.getSource()).removeFocusListener((FocusListener)this);
            ((StyledText)e.getSource()).removeDisposeListener((DisposeListener)this);
        }
    }

    private class XtextStyledTextSelectionProvider
    implements ISelectionProvider {
        private XtextStyledTextSelectionProvider() {
        }

        public void setSelection(ISelection selection) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            if (StyledTextXtextAdapter.this.styledText.isDisposed()) {
                return StructuredSelection.EMPTY;
            }
            int offset = StyledTextXtextAdapter.this.styledText.getCaretOffset() - 1;
            XtextResource fakeResource = StyledTextXtextAdapter.this.getFakeResourceContext().getFakeResource();
            IParseResult parseResult = fakeResource.getParseResult();
            if (parseResult == null) {
                return StructuredSelection.EMPTY;
            }
            ICompositeNode rootNode = parseResult.getRootNode();
            ILeafNode selectedNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)offset);
            EObject selectedObject = NodeModelUtils.findActualSemanticObjectFor((INode)selectedNode);
            if (selectedObject == null) {
                return StructuredSelection.EMPTY;
            }
            return new StructuredSelection((Object)selectedObject);
        }
    }
}

