/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.StyleCacheEntry;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignReportTemplate;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.eclipse.core.resources.IFile;

public class ExternalStylesManager {
    private static HashMap<String, StyleCacheEntry> externalStylesCache = new HashMap();
    private static HashSet<String> notEvaluableExpressions = new HashSet();
    public static final String STYLE_NOT_FOUND_EVENT = "templateReferenceNotFound";
    public static final String STYLE_FOUND_EVENT = "templateReferenceFound";

    public static void initListeners() {
    }

    private static void fireEvent(String event, Object element) {
        if (element instanceof JRChangeEventsSupport) {
            JRChangeEventsSupport eventElement = (JRChangeEventsSupport)element;
            eventElement.getEventSupport().firePropertyChange(event, null, null);
        }
    }

    public static boolean isNotValuable(String projectPath, String expression) {
        return notEvaluableExpressions.contains(String.valueOf(projectPath) + "." + expression);
    }

    public static boolean isNotValuable(MStyleTemplate template) {
        JasperReportsConfiguration jConf = template.getJasperConfiguration();
        IFile project = (IFile)jConf.get("ifile");
        String projectPath = project.getLocation().toPortableString();
        JRDesignReportTemplate jrTemplate = (JRDesignReportTemplate)template.getValue();
        String expression = jrTemplate.getSourceExpression().getText();
        return notEvaluableExpressions.contains(String.valueOf(projectPath) + "." + expression);
    }

    public static void addNotValuableExpression(String projectPath, String expression) {
        notEvaluableExpressions.add(String.valueOf(projectPath) + "." + expression);
    }

    protected static void refreshTemplte(ANode template, boolean fireEvents) {
        JasperReportsConfiguration jConf = template.getJasperConfiguration();
        IFile project = (IFile)jConf.get("ifile");
        String projectPath = project.getLocation().toPortableString();
        JRDesignReportTemplate jrTemplate = (JRDesignReportTemplate)template.getValue();
        JRExpression jrExpression = jrTemplate.getSourceExpression();
        if (jrExpression != null) {
            String expression = jrExpression.getText();
            notEvaluableExpressions.remove(String.valueOf(projectPath) + "." + expression);
            String evaluatedExpression = ExternalStylesManager.evaluateStyleExpression((JRReportTemplate)jrTemplate, project, jConf);
            if (evaluatedExpression != null) {
                String key = String.valueOf(projectPath) + evaluatedExpression;
                externalStylesCache.remove(key);
                JRTemplate loadedTemplate = ExternalStylesManager.getTemplate(jConf, evaluatedExpression);
                if (loadedTemplate != null) {
                    if (fireEvents) {
                        ExternalStylesManager.fireEvent(STYLE_FOUND_EVENT, jrTemplate);
                    }
                    return;
                }
            }
        }
        ExternalStylesManager.fireEvent(STYLE_NOT_FOUND_EVENT, jrTemplate);
    }

    public static JRTemplate getTemplate(JasperReportsConfiguration jConf, String location) {
        return ExternalStylesManager.getTemplate(jConf, location, false);
    }

    protected static JRTemplate getTemplate(JasperReportsConfiguration jConf, String location, boolean isNestedCall) {
        if (jConf != null && location != null) {
            IFile file = (IFile)jConf.get("ifile");
            String reportPath = file.getLocation().toPortableString();
            String key = String.valueOf(reportPath) + location;
            if (externalStylesCache.containsKey(key)) {
                return externalStylesCache.get(key).getTemplate();
            }
            try {
                String parentPath = file.getParent().getLocation().toFile().getAbsolutePath();
                SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
                SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jConf, (RepositoryResourceContext)context);
                byte[] data = RepositoryUtil.getInstance((RepositoryContext)repoContext).getBytesFromLocation(location);
                if (data != null) {
                    JRTemplate resolvedTemplate = JRXmlTemplateLoader.load((InputStream)new ByteArrayInputStream(data));
                    if (resolvedTemplate != null) {
                        ArrayList<JRStyle> templateStyles = new ArrayList<JRStyle>();
                        ExternalStylesManager.loadTemplateStyle(resolvedTemplate, location, jConf, templateStyles);
                        StyleCacheEntry cacheEntry = new StyleCacheEntry(resolvedTemplate, jConf, templateStyles);
                        externalStylesCache.put(key, cacheEntry);
                        if (!isNestedCall) {
                            jConf.refreshCachedStyles();
                        }
                        return resolvedTemplate;
                    }
                    StyleCacheEntry cacheEntry = new StyleCacheEntry(null, jConf, new ArrayList<JRStyle>());
                    externalStylesCache.put(key, cacheEntry);
                } else {
                    StyleCacheEntry cacheEntry = new StyleCacheEntry(null, jConf, new ArrayList<JRStyle>());
                    externalStylesCache.put(key, cacheEntry);
                }
            }
            catch (JRException e) {
                e.printStackTrace();
            }
            catch (JRRuntimeException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean validateTemplate(JasperReportsConfiguration jConfig, String location) {
        IFile file = (IFile)jConfig.get("ifile");
        String reportPath = file.getLocation().toPortableString();
        String key = String.valueOf(reportPath) + location;
        if (externalStylesCache.containsKey(key)) {
            return externalStylesCache.get(key).getTemplate() != null;
        }
        try {
            String parentPath = file.getParent().getLocation().toFile().getAbsolutePath();
            SimpleRepositoryResourceContext context = SimpleRepositoryResourceContext.of((String)parentPath);
            SimpleRepositoryContext repoContext = SimpleRepositoryContext.of((JasperReportsContext)jConfig, (RepositoryResourceContext)context);
            byte[] data = RepositoryUtil.getInstance((RepositoryContext)repoContext).getBytesFromLocation(location);
            if (data != null) {
                JRTemplate template = JRXmlTemplateLoader.load((InputStream)new ByteArrayInputStream(data));
                if (template != null) {
                    ArrayList<JRStyle> templateStyles = new ArrayList<JRStyle>();
                    ExternalStylesManager.loadTemplateStyle(template, location, jConfig, templateStyles);
                    StyleCacheEntry cacheEntry = new StyleCacheEntry(template, jConfig, templateStyles);
                    externalStylesCache.put(key, cacheEntry);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError(ex);
            return false;
        }
    }

    protected static void loadTemplateStyle(JRTemplate template, String location, JasperReportsConfiguration jConfig, List<JRStyle> result) {
        HashSet<String> loadedLocations = new HashSet<String>();
        loadedLocations.add(location);
        JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
        JRStyle[] jRStyleArray = template.getStyles();
        int n = jRStyleArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRStyle style = jRStyleArray[n2];
            result.add(style);
            ++n2;
        }
        if (includedTemplates != null) {
            int i = 0;
            while (i < includedTemplates.length) {
                JRTemplateReference reference = includedTemplates[i];
                ExternalStylesManager.loadTemplateStyles(jConfig, reference.getLocation(), loadedLocations, result);
                ++i;
            }
        }
    }

    protected static void loadTemplateStyles(JasperReportsConfiguration jConfig, String location, Set<String> loadedLocations, List<JRStyle> result) {
        if (!loadedLocations.contains(location)) {
            loadedLocations.add(location);
            JRTemplate template = ExternalStylesManager.getTemplate(jConfig, location, true);
            if (template != null) {
                JRStyle[] jRStyleArray = template.getStyles();
                int n = jRStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    JRStyle style = jRStyleArray[n2];
                    result.add(style);
                    ++n2;
                }
                JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
                if (includedTemplates != null) {
                    int i = 0;
                    while (i < includedTemplates.length) {
                        JRTemplateReference reference = includedTemplates[i];
                        ExternalStylesManager.loadTemplateStyles(jConfig, reference.getLocation(), loadedLocations, result);
                        ++i;
                    }
                }
            }
        }
    }

    public static void refreshStyle(ANode template) {
        ExternalStylesManager.refreshTemplte(template, true);
    }

    public static void refreshStyleReference(ANode template, MStyleTemplate parent) {
        JasperReportsConfiguration jConf = template.getJasperConfiguration();
        IFile project = (IFile)jConf.get("ifile");
        String projectPath = project.getLocation().toPortableString();
        JRTemplateReference jrTemplate = (JRTemplateReference)template.getValue();
        String location = jrTemplate.getLocation();
        if (location != null) {
            String key = String.valueOf(projectPath) + location;
            externalStylesCache.remove(key);
            JRTemplate loadedTemplate = ExternalStylesManager.getTemplate(jConf, location);
            if (loadedTemplate != null) {
                ExternalStylesManager.fireEvent(STYLE_FOUND_EVENT, jrTemplate);
            } else {
                ExternalStylesManager.fireEvent(STYLE_NOT_FOUND_EVENT, jrTemplate);
            }
        }
    }

    protected static String getExpressionValue(JRExpression styleExpression) {
        String expString = styleExpression != null ? styleExpression.getText() : "";
        String variableStaticPath = ExpressionUtil.extractValueForVariable("@path", expString);
        if (variableStaticPath != null) {
            return variableStaticPath;
        }
        return expString;
    }

    public static String evaluateStyleExpression(JRReportTemplate style, IFile project, JasperReportsConfiguration jConfig) {
        String evaluatedExpression = null;
        String projectPath = project.getLocation().toPortableString();
        JRExpression styleExpression = style.getSourceExpression();
        String expString = ExternalStylesManager.getExpressionValue(styleExpression);
        try {
            if (!ExternalStylesManager.isNotValuable(projectPath, expString) && (evaluatedExpression = ExpressionUtil.cachedExpressionEvaluationString((JRExpression)new JRDesignExpression(expString), jConfig)) == null) {
                ExternalStylesManager.addNotValuableExpression(projectPath, expString);
                ExternalStylesManager.fireEvent(STYLE_NOT_FOUND_EVENT, style);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ExternalStylesManager.addNotValuableExpression(projectPath, expString);
            ExternalStylesManager.fireEvent(STYLE_NOT_FOUND_EVENT, style);
        }
        return evaluatedExpression;
    }

    public static List<JRStyle> getStyles(JRReportTemplate style, IFile project, JasperReportsConfiguration jConfig) {
        String evaluatedExpression = ExternalStylesManager.evaluateStyleExpression(style, project, jConfig);
        if (evaluatedExpression != null) {
            String projectPath = project.getLocation().toPortableString();
            String key = String.valueOf(projectPath) + evaluatedExpression;
            if (externalStylesCache.containsKey(key)) {
                return externalStylesCache.get(key).getStyles();
            }
            JRTemplate loadedTemplate = ExternalStylesManager.getTemplate(jConfig, evaluatedExpression);
            if (loadedTemplate != null) {
                ExternalStylesManager.fireEvent(STYLE_FOUND_EVENT, style);
                return externalStylesCache.get(key).getStyles();
            }
            ExternalStylesManager.fireEvent(STYLE_NOT_FOUND_EVENT, style);
        }
        return new ArrayList<JRStyle>();
    }

    public static boolean isTemplateValid(MStyleTemplate template) {
        JasperReportsConfiguration jConfig = template.getJasperConfiguration();
        IFile project = (IFile)jConfig.get("ifile");
        return ExternalStylesManager.isTemplateValid((JRReportTemplate)template.getValue(), project, jConfig);
    }

    public static boolean isTemplateValid(JRReportTemplate style, IFile project, JasperReportsConfiguration jConfig) {
        String evaluatedExpression = ExternalStylesManager.evaluateStyleExpression(style, project, jConfig);
        if (evaluatedExpression != null) {
            String projectPath = project.getLocation().toPortableString();
            String key = String.valueOf(projectPath) + evaluatedExpression;
            if (externalStylesCache.containsKey(key)) {
                return externalStylesCache.get(key).getTemplate() != null;
            }
            JRTemplate loadedTemplate = ExternalStylesManager.getTemplate(jConfig, evaluatedExpression);
            if (loadedTemplate != null) {
                return externalStylesCache.get(key).getTemplate() != null;
            }
        }
        return false;
    }

    private static JRStyle searchStyleInList(List<JRStyle> jrStylesList, String searchedName) {
        for (JRStyle style : jrStylesList) {
            if (!searchedName.equals(style.getName())) continue;
            return style;
        }
        return null;
    }

    public static JRStyle getExternalStyle(String styleName, JasperReportsConfiguration jConfig) {
        JasperDesign design = jConfig.getJasperDesign();
        if (design != null) {
            IFile project = (IFile)jConfig.get("ifile");
            for (JRReportTemplate template : design.getTemplatesList()) {
                List<JRStyle> loadedStyles = ExternalStylesManager.getStyles(template, project, jConfig);
                JRStyle searchedStyle = ExternalStylesManager.searchStyleInList(loadedStyles, styleName);
                if (searchedStyle == null) continue;
                return searchedStyle;
            }
        }
        return null;
    }

    public static synchronized void removeCachedStyles(JasperReportsConfiguration jConfig) {
        ArrayList<Map.Entry<String, StyleCacheEntry>> entries = new ArrayList<Map.Entry<String, StyleCacheEntry>>(externalStylesCache.entrySet());
        for (Map.Entry entry : entries) {
            if (((StyleCacheEntry)entry.getValue()).getConfig() != jConfig) continue;
            externalStylesCache.remove(entry.getKey());
        }
    }

    public static synchronized void removeCachedStyle(JasperReportsConfiguration jConfig, JRReportTemplate template) {
        IFile project = (IFile)jConfig.get("ifile");
        String evaluatedExpression = ExternalStylesManager.evaluateStyleExpression(template, project, jConfig);
        if (evaluatedExpression != null) {
            String projectPath = project.getLocation().toPortableString();
            String key = String.valueOf(projectPath) + evaluatedExpression;
            externalStylesCache.remove(key);
        }
    }
}

