/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.backward;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import net.sf.jasperreports.eclipse.builder.JRDefinition;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.util.ZipFilter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Async;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.concurrent.FutureCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.util.Util;

public class JRBackwardManager {
    private static final String JR_TOOLKIT_JAR_INTERNAL_LOCATION = "com/jaspersoft/studio/backward/resources/JRToolKit.jar";
    private static final String JR_TOOLKIT_JAR_FILENAME = "JRToolKit.jar";
    protected static final String JR_COMPILER_STORAGE = "jrCompilers";
    private static final String BUILD_FOLDER = "dist";
    private static final String LIB_FOLDER = "lib";
    public static File storage = ConfigurationManager.getStorage("jrCompilers");

    private static void fetchResource(String path, File destinationDir, String fileName) {
        File dfile = new File(destinationDir, fileName);
        if (dfile.exists()) {
            return;
        }
        URL url = ((Object)((Object)JaspersoftStudioPlugin.getInstance())).getClass().getClassLoader().getResource(path);
        InputStream is = null;
        try {
            try {
                is = url.openStream();
                FileUtils.copyInputStreamToFile((InputStream)is, (File)dfile);
            }
            catch (Exception ex) {
                JaspersoftStudioPlugin.getInstance().logError(MessageFormat.format(Messages.JRBackwardManager_dowloadError, path), ex);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
            }
        }
        finally {
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
        }
    }

    public static void copyJRToolkitUtility(File destinationDir) {
        JRBackwardManager.fetchResource(JR_TOOLKIT_JAR_INTERNAL_LOCATION, destinationDir, JR_TOOLKIT_JAR_FILENAME);
    }

    public static void fetchJR(JRDefinition def, final File toDir, final IProgressMonitor monitor) throws Exception {
        Executor exec = Executor.newInstance();
        final URI fullURI = new URI(def.getResourceURL());
        HttpUtils.setupProxy((Executor)exec, (URI)fullURI);
        HttpHost proxy = HttpUtils.getUnauthProxy((Executor)exec, (URI)fullURI);
        Request req = Request.Get((String)def.getResourceURL());
        if (proxy != null) {
            req.viaProxy(proxy);
        }
        Future future = Async.newInstance().use(exec).execute(req, (ResponseHandler)new ResponseHandler<Content>(){

            public Content handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                Header[] headers;
                StatusLine statusLine = response.getStatusLine();
                HttpEntity entity = response.getEntity();
                if (statusLine.getStatusCode() >= 300) {
                    throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                }
                if (entity == null) {
                    throw new ClientProtocolException("Response contains no content");
                }
                Header[] headerArray = headers = response.getHeaders("Content-Type");
                int n = headers.length;
                int n2 = 0;
                while (n2 < n) {
                    Header h = headerArray[n2];
                    if (h.getValue().equals("application/java-archive")) {
                        FileUtils.copyInputStreamToFile((InputStream)entity.getContent(), (File)new File(toDir, FilenameUtils.getName((String)fullURI.getPath())));
                        return null;
                    }
                    ++n2;
                }
                net.sf.jasperreports.eclipse.util.FileUtils.unZip((InputStream)entity.getContent(), (File)toDir, (IProgressMonitor)monitor, (ZipFilter)new ZipFilter(){

                    public boolean isNecessary(String[] pathComponents) {
                        if (pathComponents.length > 1) {
                            if (JRBackwardManager.BUILD_FOLDER.equals(pathComponents[1]) || JRBackwardManager.BUILD_FOLDER.equals(pathComponents[0])) {
                                return true;
                            }
                            if (JRBackwardManager.LIB_FOLDER.equals(pathComponents[1]) || JRBackwardManager.LIB_FOLDER.equals(pathComponents[0])) {
                                return true;
                            }
                        }
                        return false;
                    }
                });
                return null;
            }
        }, (FutureCallback)new FutureCallback<Content>(){

            public void failed(Exception ex) {
                ex.printStackTrace();
            }

            public void completed(Content content) {
            }

            public void cancelled() {
            }
        });
        while (!future.isDone() && !future.isCancelled()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (!monitor.isCanceled()) continue;
            future.cancel(true);
            return;
        }
    }

    public static void deleteJR(JRDefinition def) throws IOException {
        File jrPath = new File(def.getResourceURL());
        if (jrPath.exists()) {
            FileUtils.deleteDirectory((File)jrPath);
        }
    }

    public static boolean download(JRDefinition d, IProgressMonitor monitor) throws Exception {
        File destDir;
        File path;
        block7: {
            path = null;
            try {
                path = net.sf.jasperreports.eclipse.util.FileUtils.createTempDir((String)"jrkit");
                JRBackwardManager.fetchJR(d, path, monitor);
                d.setVersion(JRBackwardManager.verify(path.getAbsolutePath()));
                destDir = new File(storage, d.getVersion());
                d.setResourceURL(destDir.getAbsolutePath());
                if (!destDir.exists()) break block7;
                if (UIUtils.showConfirmation((String)"Confirmation", (String)"This version already exists , do you want to replace existing one?")) {
                    FileUtils.deleteDirectory((File)destDir);
                    break block7;
                }
                FileUtils.deleteDirectory((File)path);
                return false;
            }
            catch (Exception e) {
                if (path != null) {
                    path.delete();
                }
                throw e;
            }
        }
        if (Util.isWindows()) {
            FileUtils.copyDirectory((File)path, (File)destDir);
            path.delete();
        } else {
            FileUtils.moveDirectory((File)path, (File)destDir);
        }
        JRBackwardManager.fetchResource(JR_TOOLKIT_JAR_INTERNAL_LOCATION, destDir, JR_TOOLKIT_JAR_FILENAME);
        return true;
    }

    public static String verify(String path) throws Exception {
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        if (Misc.isNullOrEmpty((String)path)) {
            throw new Exception("Paths is empty.");
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new Exception("Path does not exists.");
        }
        if (!f.isDirectory()) {
            throw new Exception("Path is not a directory.");
        }
        Collection lf = FileUtils.listFiles((File)f, (String[])new String[]{"jar", "zip", "jar"}, (boolean)true);
        ArrayList<File> files = new ArrayList<File>();
        if (lf != null) {
            files.addAll(lf);
        }
        files.add(f);
        URL[] urls = FileUtils.toURLs((File[])files.toArray(new File[files.size()]));
        URLClassLoader cl = new URLClassLoader(urls);
        try {
            Class<?> c = cl.loadClass("net.sf.jasperreports.engine.JasperCompileManager");
            return c.getPackage().getImplementationVersion();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("There is no JRCompiler");
        }
    }
}

