/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.backward.wizard;

import com.jaspersoft.studio.backward.JRBackwardManager;
import com.jaspersoft.studio.messages.Messages;
import java.io.File;
import net.sf.jasperreports.eclipse.builder.JRDefinition;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JRVersionPathDialog
extends ATitledDialog {
    private JRDefinition value;

    protected JRVersionPathDialog(Shell parentShell, JRDefinition value) {
        super(parentShell);
        this.setTitle(Messages.JRVersionPathDialog_0);
        this.setDefaultSize(450, 250);
        this.value = value;
    }

    public JRDefinition getValue() {
        return this.value;
    }

    protected Control createDialogArea(final Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(cmp, 0);
        lbl.setText(Messages.JRVersionPathDialog_1);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        lbl.setLayoutData((Object)gd);
        this.setDescription(Messages.JRVersionPathDialog_description);
        final Text tpath = new Text(cmp, 2048);
        tpath.setLayoutData((Object)new GridData(768));
        tpath.setTextLimit(300);
        tpath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button okButton = JRVersionPathDialog.this.getButton(0);
                if (new File(tpath.getText()).exists()) {
                    try {
                        JRVersionPathDialog.this.value.setVersion(JRBackwardManager.verify(tpath.getText()));
                        JRVersionPathDialog.this.value.setResourceURL(tpath.getText());
                        JRVersionPathDialog.this.setError(null);
                        okButton.setEnabled(true);
                        return;
                    }
                    catch (Exception e1) {
                        JRVersionPathDialog.this.setError(e1.getMessage());
                        okButton.setEnabled(false);
                        return;
                    }
                }
                okButton.setEnabled(false);
                JRVersionPathDialog.this.setError(Messages.JRVersionPathDialog_2);
            }
        });
        Button b = new Button(cmp, 8);
        b.setText(Messages.JRVersionPathDialog_3);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(parent.getShell());
                if (JRVersionPathDialog.this.value != null && !Misc.isNullOrEmpty((String)JRVersionPathDialog.this.value.getResourceURL())) {
                    dlg.setFilterPath(JRVersionPathDialog.this.value.getResourceURL());
                }
                dlg.setText(JRVersionPathDialog.this.title);
                dlg.setMessage(JRVersionPathDialog.this.title);
                String dir = dlg.open();
                if (dir != null) {
                    tpath.setText(dir);
                    JRVersionPathDialog.this.value.setResourceURL(tpath.getText());
                }
            }
        });
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                tpath.setText(JRVersionPathDialog.this.value.getResourceURL());
            }
        });
        return cmp;
    }
}

