/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.callout;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.callout.CalloutEditManager;
import com.jaspersoft.studio.callout.CalloutFigure;
import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.callout.pin.MPinConnection;
import com.jaspersoft.studio.callout.pin.PinConnectorEditPart;
import com.jaspersoft.studio.editor.gef.figures.FigureFactory;
import com.jaspersoft.studio.editor.gef.figures.ReportPageFigure;
import com.jaspersoft.studio.editor.gef.parts.AJDEditPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ElementEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.SearchParentDragTracker;
import com.jaspersoft.studio.editor.gef.parts.text.LabelCellEditorLocator;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.SetValueCommand;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wb.swt.SWTResourceManager;

public class CalloutEditPart
extends AJDEditPart
implements PropertyChangeListener,
NodeEditPart {
    private PreferenceListener preferenceListener;
    private CalloutEditManager manager;
    protected JasperReportsConfiguration jConfig;
    private ChopboxAnchor m_anchor;

    protected void handlePreferenceChanged(PropertyChangeEvent event) {
        this.refreshVisuals();
    }

    @Override
    public void activate() {
        super.activate();
        this.preferenceListener = new PreferenceListener();
        JaspersoftStudioPlugin.getInstance().addPreferenceListener(this.preferenceListener, this.getAssociatedFile());
    }

    @Override
    public void deactivate() {
        if (this.preferenceListener != null) {
            JaspersoftStudioPlugin.getInstance().removePreferenceListener(this.preferenceListener);
        }
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        MCallout model = this.getModel();
        IFigure rect = FigureFactory.createFigure(model);
        this.setupFigure(rect);
        this.m_anchor = new ChopboxAnchor(rect);
        return rect;
    }

    public DragTracker getDragTracker(Request request) {
        return new SearchParentDragTracker((EditPart)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected void showCurrentEditValue(DirectEditRequest request) {
                CalloutEditPart.this.getFigure().getUpdateManager().performUpdate();
            }

            protected Command getDirectEditCommand(DirectEditRequest request) {
                SetValueCommand cmd = new SetValueCommand();
                cmd.setTarget((IPropertySource)this.getHost().getModel());
                cmd.setPropertyId("TEXT");
                CellEditor cellEditor = request.getCellEditor();
                cmd.setPropertyValue((String)cellEditor.getValue());
                return cmd;
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ElementEditPolicy());
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            if (this.manager == null) {
                this.manager = new CalloutEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this.getFigure()));
            }
            this.manager.show();
        }
    }

    public void refreshVisuals() {
        IFigure rect = this.getFigure();
        if (Display.getCurrent() != null) {
            this.setupFigure(rect);
            rect.invalidate();
            rect.repaint();
        }
    }

    public JasperReportsConfiguration getjConfig() {
        return this.jConfig;
    }

    protected void setupFigure(IFigure rect) {
        MCallout model = this.getModel();
        rect.setToolTip((IFigure)new Label(((ANode)model).getToolTip()));
        MCallout m = this.getModel();
        int x = (Integer)m.getPropertyValue("x") + ReportPageFigure.PAGE_BORDER.left;
        int y = (Integer)m.getPropertyValue("y") + ReportPageFigure.PAGE_BORDER.top;
        int w = (Integer)m.getPropertyValue("width");
        int h = (Integer)m.getPropertyValue("height");
        String text = (String)m.getPropertyValue("TEXT");
        ((CalloutFigure)rect).setText(text);
        rect.setBackgroundColor(SWTResourceManager.getColor((RGB)AlfaRGB.safeGetRGB((AlfaRGB)m.getPropertyValue("BACKGROUND"))));
        rect.setForegroundColor(SWTResourceManager.getColor((RGB)AlfaRGB.safeGetRGB((AlfaRGB)m.getPropertyValue("FOREGROUND"))));
        rect.setBounds(new Rectangle(x, y, w, h));
    }

    public MCallout getModel() {
        return (MCallout)super.getModel();
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.refresh();
        this.refreshVisuals();
    }

    protected ConnectionEditPart createConnection(Object model) {
        PinConnectorEditPart connectPart = (PinConnectorEditPart)((Object)this.getRoot().getViewer().getEditPartRegistry().get(model));
        if (connectPart == null) {
            connectPart = new PinConnectorEditPart();
            connectPart.setModel(model);
        }
        return connectPart;
    }

    protected List<?> getModelTargetConnections() {
        ArrayList<MPinConnection> sourceConnections = new ArrayList<MPinConnection>();
        sourceConnections.addAll(this.getModel().getTargetConnections());
        return sourceConnections;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.m_anchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.m_anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    private final class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            CalloutEditPart.this.handlePreferenceChanged(event);
        }
    }
}

