/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.callout;

import com.jaspersoft.studio.callout.pin.IPinContainer;
import com.jaspersoft.studio.callout.pin.MPin;
import com.jaspersoft.studio.callout.pin.MPinConnection;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IDesignDragable;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.swt.SWTResourceManager;

public class MCallout
extends APropertyNode
implements IGraphicElement,
IDesignDragable {
    public static final long serialVersionUID = 10200L;
    public static final int DEFAULT_HEIGHT = 200;
    public static final int DEFAULT_WIDTH = 200;
    public static final String PROP_CALLOUT = "ireport.callouts";
    private static IIconDescriptor iconDescriptor;
    private IPropertyDescriptor[] descriptors;
    private List<MPinConnection> pinConnections = new ArrayList<MPinConnection>();
    public static final String PROP_TEXT = "TEXT";
    public static final String PROP_BACKGROUND = "BACKGROUND";
    public static final String PROP_FOREGROUND = "FOREGROUND";
    private int x;
    private int y;
    private int w;
    private int h;
    private int i = 100;
    private Color fg = ColorConstants.black;
    private Color bg = ColorConstants.yellow;
    private String text = String.valueOf(System.getProperty("user.name")) + " " + new SimpleDateFormat().format(new Date());
    private Properties properties;

    public MCallout() {
    }

    public MCallout(ANode parent, Properties properties, int icallout) {
        super(parent, -1);
        this.properties = properties;
        this.parseCallout(icallout);
        this.setValue(this.getJasperDesign());
    }

    public MCallout(ANode parent) {
        super(parent, -1);
        this.setValue(this.getJasperDesign());
    }

    public void deleteCallout() {
        ANode parent = this.getParent();
        if (parent != null) {
            this.properties = MCallout.getProperities(parent);
            this.properties.remove("callouts." + this.i + ".bounds");
            this.properties.remove("callouts." + this.i + ".pins");
            this.properties.remove("callouts." + this.i + ".text");
            this.properties.remove("callouts." + this.i + ".pins");
            this.properties.remove("callouts." + this.i + ".bg");
            this.properties.remove("callouts." + this.i + ".fg");
            String calloutInfoStr = FileUtils.getPropertyAsString((Properties)this.properties);
            if (calloutInfoStr == null || calloutInfoStr.isEmpty()) {
                MCallout.getPinPropertyHolder(parent).getPropertiesMap().removeProperty(PROP_CALLOUT);
            } else {
                MCallout.getPinPropertyHolder(parent).getPropertiesMap().setProperty(PROP_CALLOUT, calloutInfoStr);
            }
            this.removeChild(this);
            this.getPropertyChangeSupport().fireIndexedPropertyChange("children", -1, true, false);
        }
    }

    public static MCallout createCallout(ANode parent, Rectangle location) {
        Properties properties = MCallout.getProperities(parent);
        Set<Object> keySet = properties.keySet();
        int max = 0;
        for (Object key : keySet) {
            String k = (String)key;
            if (!k.matches("callouts\\.[0-9]\\.bounds")) continue;
            int tmp = Integer.parseInt(k.replaceAll("callouts\\.", "").replaceAll("\\.bounds", ""));
            max = Math.max(tmp, max);
        }
        MCallout mCallout = new MCallout(parent, properties, max + 1);
        mCallout.setPropertyValue("x", location.x);
        mCallout.setPropertyValue("y", location.y);
        mCallout.setPropertyValue("width", location.width);
        mCallout.setPropertyValue("height", location.height);
        parent.getPropertyChangeSupport().fireIndexedPropertyChange("children", -1, true, false);
        return mCallout;
    }

    public static Properties getProperities(ANode parent) {
        try {
            JRPropertiesHolder pholder = MCallout.getPinPropertyHolder(parent);
            String pcallout = pholder.getPropertiesMap().getProperty(PROP_CALLOUT);
            if (pcallout != null) {
                pcallout = pcallout.replaceAll("callouts.", "\ncallouts.");
                return FileUtils.load((String)pcallout);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Properties();
    }

    public static void createCallouts(ANode parent) {
        Properties properties = MCallout.getProperities(parent);
        if (properties != null) {
            Set<Object> keySet = properties.keySet();
            HashSet<Integer> indexset = new HashSet<Integer>();
            for (Object key : keySet) {
                String k = (String)key;
                if (!k.matches("callouts\\.[0-9]\\.bounds")) continue;
                indexset.add(Integer.parseInt(k.replaceAll("callouts\\.", "").replaceAll("\\.bounds", "")));
            }
            for (Integer ind : indexset) {
                new MCallout(parent, properties, (int)ind);
            }
        }
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("note");
        }
        return iconDescriptor;
    }

    @Override
    public String getDisplayText() {
        return MCallout.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MCallout.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MCallout.getIconDescriptor().getToolTip();
    }

    @Override
    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    @Override
    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    @Override
    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        NTextPropertyDescriptor textD = new NTextPropertyDescriptor(PROP_TEXT, "Text", 2);
        desc.add((IPropertyDescriptor)textD);
        ColorPropertyDescriptor backcolorD = new ColorPropertyDescriptor(PROP_BACKGROUND, Messages.common_backcolor, NullEnum.NOTNULL, false);
        backcolorD.setDescription("Background color of the callout");
        desc.add((IPropertyDescriptor)backcolorD);
        ColorPropertyDescriptor foreColorD = new ColorPropertyDescriptor(PROP_FOREGROUND, Messages.common_forecolor, NullEnum.NOTNULL, false);
        foreColorD.setDescription("Foreground color of the callout");
        desc.add((IPropertyDescriptor)foreColorD);
    }

    @Override
    protected Map<String, DefaultValue> createDefaultsMap() {
        Map<String, DefaultValue> defaultsMap = super.createDefaultsMap();
        defaultsMap.put(PROP_BACKGROUND, new DefaultValue(ColorConstants.yellow, false));
        defaultsMap.put(PROP_FOREGROUND, new DefaultValue(ColorConstants.black, false));
        return defaultsMap;
    }

    public void parseCallout(int icallout) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.i = icallout;
        String b = this.properties.getProperty("callouts." + this.i + ".bounds");
        if (b != null) {
            String[] coords = b.split(",");
            this.x = this.getInt(coords[0]);
            this.y = this.getInt(coords[1]);
            this.w = this.getInt(coords[2]);
            this.h = this.getInt(coords[3]);
        }
        if ((b = this.properties.getProperty("callouts." + this.i + ".fg")) != null) {
            this.fg = this.getColor(b, this.fg);
        }
        if ((b = this.properties.getProperty("callouts." + this.i + ".bg")) != null) {
            this.bg = this.getColor(b, this.bg);
        }
        this.removeChildren();
        String pins = this.properties.getProperty("callouts." + this.i + ".pins");
        if (pins != null) {
            String[] ps;
            String[] stringArray = ps = pins.trim().split(";");
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                String pin = stringArray[n2];
                String[] p = pin.split(",");
                MPin mpin = new MPin((ANode)this, new Point(this.getInt(p[0]), this.getInt(p[1])));
                new MPinConnection(this, mpin);
                ++n2;
            }
        }
        this.text = Misc.nvl((Object)this.properties.getProperty("callouts." + this.i + ".text"), (String)this.text);
    }

    public void addPinConnection(MPinConnection conn) {
        this.pinConnections.add(conn);
    }

    public void removePinConnection(MPinConnection conn) {
        this.pinConnections.remove(conn);
    }

    public List<MPinConnection> getTargetConnections() {
        return this.pinConnections;
    }

    private Color getColor(String str, Color def) {
        try {
            return SWTResourceManager.getColor((RGB)StringConverter.asRGB((String)str));
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    private int getInt(String str) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("x")) {
            return this.x;
        }
        if (id.equals("y")) {
            return this.y;
        }
        if (id.equals("width")) {
            return this.w;
        }
        if (id.equals("height")) {
            return this.h;
        }
        if (id.equals(PROP_TEXT)) {
            return this.text;
        }
        if (id.equals(PROP_FOREGROUND)) {
            return AlfaRGB.getFullyOpaque(this.fg.getRGB());
        }
        if (id.equals(PROP_BACKGROUND)) {
            return AlfaRGB.getFullyOpaque(this.bg.getRGB());
        }
        return null;
    }

    public void setPropertyValue(Object id, Object value) {
        Object oldValue = this.getPropertyValue(id);
        if (id.equals("x")) {
            this.x = (Integer)value;
        } else if (id.equals("y")) {
            this.y = (Integer)value;
        } else if (id.equals("width")) {
            this.w = (Integer)value;
        } else if (id.equals("height")) {
            this.h = (Integer)value;
        } else if (id.equals(PROP_TEXT)) {
            this.text = Misc.nvl((Object)value, (String)"");
        } else if (id.equals(PROP_FOREGROUND)) {
            this.fg = SWTResourceManager.getColor((RGB)AlfaRGB.safeGetRGB((AlfaRGB)value));
        } else if (id.equals(PROP_BACKGROUND)) {
            this.bg = SWTResourceManager.getColor((RGB)AlfaRGB.safeGetRGB((AlfaRGB)value));
        }
        this.properties = MCallout.getProperities(this.getParent());
        this.properties.setProperty("callouts." + this.i + ".bounds", String.valueOf(this.x) + "," + this.y + "," + this.w + "," + this.h);
        this.properties.setProperty("callouts." + this.i + ".text", this.text);
        this.properties.setProperty("callouts." + this.i + ".bg", StringConverter.asString((RGB)this.bg.getRGB()));
        this.properties.setProperty("callouts." + this.i + ".fg", StringConverter.asString((RGB)this.fg.getRGB()));
        String pins = "";
        List<INode> children = this.getChildren();
        for (INode ch : children) {
            if (!(ch instanceof MPin)) continue;
            MPin pin = (MPin)ch;
            if (!pins.isEmpty()) {
                pins = String.valueOf(pins) + ";";
            }
            pins = String.valueOf(pins) + pin.getPropertyValue("x") + "," + pin.getPropertyValue("y");
        }
        if (!pins.isEmpty()) {
            this.properties.setProperty("callouts." + this.i + ".pins", pins);
        } else {
            this.properties.remove("callouts." + this.i + ".pins");
        }
        MCallout.getPinPropertyHolder(this.getParent()).getPropertiesMap().setProperty(PROP_CALLOUT, FileUtils.getPropertyAsString((Properties)this.properties).replace("\n", "\\n"));
        this.getPropertyChangeSupport().firePropertyChange((String)id, oldValue, value);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    @Override
    public int getDefaultWidth() {
        return 200;
    }

    @Override
    public int getDefaultHeight() {
        return 200;
    }

    @Override
    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    @Override
    public Rectangle getJRBounds() {
        return this.getBounds();
    }

    public static IPinContainer getPinPropertyHolderNode(ANode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof IPinContainer) {
            return (IPinContainer)((Object)node);
        }
        if (node instanceof MPage) {
            return MCallout.getPinPropertyHolderNode((ANode)node.getChildren().get(node.getChildren().size() - 1));
        }
        return MCallout.getPinPropertyHolderNode(node.getParent());
    }

    public static JRPropertiesHolder getPinPropertyHolder(ANode parent) {
        JRPropertiesHolder[] pholders;
        IPinContainer pHolderNode = MCallout.getPinPropertyHolderNode(parent);
        if (pHolderNode != null && (pholders = pHolderNode.getPropertyHolder()) != null) {
            return pholders[pholders.length - 1];
        }
        return parent.getJasperDesign();
    }
}

