/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.callout;

import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.utils.Colors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.swt.graphics.Cursor;

public class SothEastRectangleHandles
extends ResizeHandle {
    protected static int JSS_HANDLE_SIZE = 24;
    private Color bcolor;

    public SothEastRectangleHandles(GraphicalEditPart owner, Locator loc, Cursor c) {
        super(owner, loc, c);
    }

    public SothEastRectangleHandles(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void init() {
        super.init();
        this.setPreferredSize(new Dimension(JSS_HANDLE_SIZE, JSS_HANDLE_SIZE));
    }

    public void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r.shrink(1, 1);
        try {
            Graphics2D gr = ComponentFigure.getG2D(g);
            if (g != null) {
                if (this.bcolor == null) {
                    this.bcolor = Colors.getAWT4SWTColor(((LineBorder)this.getOwnerFigure().getBorder()).getColor());
                }
                gr.setColor(this.bcolor);
                gr.setStroke(new BasicStroke(1.0f));
                Polygon p = new Polygon();
                p.addPoint(r.x, r.y + r.height / 2);
                p.addPoint(r.x + r.width / 2, r.y);
                p.addPoint(r.x + r.width / 2, r.y + r.height / 2);
                gr.fillPolygon(p);
                gr.setColor(Colors.getAWT4SWTColor(this.getForegroundColor()));
                gr.drawLine(r.x, r.y + r.height / 2, r.x + r.width / 2, r.y);
            }
        }
        finally {
            r.expand(1, 1);
        }
    }

    public void setSize(int newSize) {
        JSS_HANDLE_SIZE = newSize;
    }
}

