/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter;

import com.jaspersoft.studio.custom.adapter.AdapterInfo;
import com.jaspersoft.studio.utils.VelocityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DynamicCompositeHelper {
    private static final String TEMPLATES_LOCATION_PREFIX = "com/jaspersoft/studio/custom/adapter/resources/dynamic/";
    private static final String TEXT_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/TextValueControl.vm";
    private static final String BOOLEAN_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/BooleanValueControl.vm";
    private static final String FLOAT_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/FloatValueControl.vm";
    private static final String INTEGER_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/IntegerValueControl.vm";
    private static final String LIST_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/ListValueControl.vm";
    private static final String COMPOSITE_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/dynamic/DynamicComposite.vm";
    private JarFile jarFile;
    private AdapterInfo adapterInfo;
    private VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();

    public DynamicCompositeHelper(File jarFile, AdapterInfo adapterInfo) {
        try {
            this.jarFile = new JarFile(jarFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.adapterInfo = adapterInfo;
    }

    public String getCompositeClass() {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)this.adapterInfo.getPackageName());
        functionContext.put("adapterComposite", (Object)this.adapterInfo.getCompositeClassName());
        functionContext.put("descriptorName", (Object)this.adapterInfo.getDescriptorClassName());
        Template functionTemplate = this.ve.getTemplate(COMPOSITE_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionContext.put("controlCreationCode", (Object)this.createDynamicControls());
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    protected String getXmlDefinitionLocation() {
        Properties props = new Properties();
        try {
            ZipEntry propertiesFile = this.jarFile.getEntry("jasperreports_extension.properties");
            if (propertiesFile == null) {
                throw new RuntimeException("The file jasperreports_extension.properties can't be found inside the selected JAR");
            }
            props.load(this.jarFile.getInputStream(propertiesFile));
            for (Object property : props.keySet()) {
                if (!property.toString().startsWith("net.sf.jasperreports.extension.castor.mapping")) continue;
                return props.getProperty(property.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String createDynamicControl(String type, String bindName, String label) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("controlLabel", (Object)label);
        functionContext.put("controlName", (Object)(String.valueOf(label) + "Control"));
        functionContext.put("bindName", (Object)bindName);
        StringWriter fsw = new StringWriter();
        if (type.equals("int")) {
            Template functionTemplate = this.ve.getTemplate(INTEGER_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        } else if (type.equals("boolean")) {
            Template functionTemplate = this.ve.getTemplate(BOOLEAN_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        } else if (type.equals("float")) {
            Template functionTemplate = this.ve.getTemplate(FLOAT_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        } else if (type.equals("string")) {
            Template functionTemplate = this.ve.getTemplate(TEXT_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        }
        return fsw.toString();
    }

    protected String createDynamicArray(String type, String bindName, String label) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("controlLabel", (Object)label);
        functionContext.put("controlName", (Object)(String.valueOf(label) + "Control"));
        functionContext.put("bindName", (Object)bindName);
        functionContext.put("elementType", (Object)type);
        StringWriter fsw = new StringWriter();
        Template functionTemplate = this.ve.getTemplate(LIST_TEMPLATE_LOCATION);
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private Node getBindNode(Node parent) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("bind-xml")) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected String createDynamicControls(NodeList fieldNodes) {
        String result = "";
        int i = 0;
        while (i < fieldNodes.getLength()) {
            String nameAttribute;
            Node fieldNode = fieldNodes.item(i);
            if (fieldNode.getNodeName().equals("field") && !(nameAttribute = fieldNode.getAttributes().getNamedItem("name").getNodeValue()).equals("class") && !nameAttribute.equals("name")) {
                String type = fieldNode.getAttributes().getNamedItem("type").getNodeValue();
                Node collectionNode = fieldNode.getAttributes().getNamedItem("collection");
                boolean isArray = collectionNode != null && collectionNode.getNodeValue().toLowerCase().equals("arraylist");
                Node bindNode = this.getBindNode(fieldNode);
                if (bindNode != null) {
                    String name = fieldNode.getAttributes().getNamedItem("name").getNodeValue();
                    String bindName = bindNode.getAttributes().getNamedItem("name").getNodeValue();
                    result = isArray ? String.valueOf(result) + this.createDynamicArray(type, bindName, name) : String.valueOf(result) + this.createDynamicControl(type, bindName, name) + "\n";
                }
            }
            ++i;
        }
        return result;
    }

    protected String createDynamicControls() {
        String xmlDefinition = this.getXmlDefinitionLocation();
        if (xmlDefinition != null) {
            ZipEntry xmlFile = this.jarFile.getEntry(xmlDefinition);
            InputStream is = null;
            try {
                is = this.jarFile.getInputStream(xmlFile);
                if (is != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setValidating(false);
                    dbf.setIgnoringComments(true);
                    dbf.setNamespaceAware(false);
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    builder.setEntityResolver(new EntityResolver(){

                        @Override
                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                            if (systemId.contains("http://castor.org/mapping.dtd")) {
                                return new InputSource(new StringReader(""));
                            }
                            return null;
                        }
                    });
                    Document document = builder.parse(is);
                    Element mapNode = document.getDocumentElement();
                    if (mapNode.getNodeName().equals("mapping")) {
                        NodeList adapterNodes = mapNode.getChildNodes();
                        int j = 0;
                        while (j < adapterNodes.getLength()) {
                            Node adapterNode = adapterNodes.item(j);
                            if (adapterNode.getNodeName().equals("class")) {
                                String result = this.createDynamicControls(adapterNode.getChildNodes());
                                is.close();
                                return result;
                            }
                            ++j;
                        }
                    }
                }
            }
            catch (Exception ex) {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
                ex.printStackTrace();
            }
        }
        return "";
    }
}

