/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter;

import com.jaspersoft.studio.custom.adapter.Pair;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.AbstractDataAdapter;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterContributorFactory;

public class LoadedClassesContainer {
    private List<Pair> adapterInterfaces = new ArrayList<Pair>();
    private List<Pair> adapterImplementation = new ArrayList<Pair>();
    private List<Pair> service = new ArrayList<Pair>();
    private List<Pair> serviceFatory = new ArrayList<Pair>();

    public void addClass(Class<?> loadedClass) {
        if (loadedClass.isInterface() && DataAdapter.class.isAssignableFrom(loadedClass)) {
            this.adapterInterfaces.add(new Pair(loadedClass.getPackage().getName(), loadedClass.getSimpleName()));
        } else if (!loadedClass.isInterface() && AbstractDataAdapter.class.isAssignableFrom(loadedClass)) {
            this.adapterImplementation.add(new Pair(loadedClass.getPackage().getName(), loadedClass.getSimpleName()));
        } else if (!loadedClass.isInterface() && AbstractDataAdapterService.class.isAssignableFrom(loadedClass)) {
            this.service.add(new Pair(loadedClass.getPackage().getName(), loadedClass.getSimpleName()));
        } else if (!loadedClass.isInterface() && DataAdapterContributorFactory.class.isAssignableFrom(loadedClass)) {
            this.serviceFatory.add(new Pair(loadedClass.getPackage().getName(), loadedClass.getSimpleName()));
        }
    }

    public List<Pair> getAdapterInterfaces() {
        return this.adapterInterfaces;
    }

    public List<Pair> getAdapterImplementation() {
        return this.adapterImplementation;
    }

    public List<Pair> getService() {
        return this.service;
    }

    public List<Pair> getServiceFatory() {
        return this.serviceFatory;
    }

    public static String[] converToArray(List<Pair> pairList) {
        String[] result = new String[pairList.size()];
        int i = 0;
        for (Pair pair : pairList) {
            result[i] = pair.toString();
            ++i;
        }
        return result;
    }

    public static Pair convertToPair(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        int classSeparator = value.lastIndexOf(".");
        String className = "";
        String packageName = "";
        if (classSeparator == -1) {
            className = value;
        } else {
            packageName = value.substring(0, classSeparator);
            className = value.substring(classSeparator + 1);
        }
        return new Pair(packageName, className);
    }
}

