/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.custom.adapter.AdapterInfo;
import com.jaspersoft.studio.custom.adapter.LoadedClassesContainer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public class PluginHelper {
    public static IProject createPluginProject(AdapterInfo adapterInfo, List<String> srcFolders, List<String> requiredBundles, List<File> requiredLibs, IProgressMonitor progressMonitor) {
        IProject project = null;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(adapterInfo.getProjectName());
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(adapterInfo.getProjectName());
            projectDescription.setLocation(null);
            project.create(projectDescription, progressMonitor);
            ArrayList<Object> classpathEntries = new ArrayList<Object>();
            projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature"});
            ICommand java = projectDescription.newCommand();
            java.setBuilderName("org.eclipse.jdt.core.javabuilder");
            ICommand manifest = projectDescription.newCommand();
            manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
            ICommand schema = projectDescription.newCommand();
            schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
            ICommand oaw = projectDescription.newCommand();
            projectDescription.setBuildSpec(new ICommand[]{java, manifest, schema, oaw});
            project.open(progressMonitor);
            project.setDescription(projectDescription, progressMonitor);
            Collections.reverse(srcFolders);
            for (String src : srcFolders) {
                IFolder srcContainer = project.getFolder(src);
                if (!srcContainer.exists()) {
                    srcContainer.create(false, true, progressMonitor);
                }
                IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                classpathEntries.add(0, srcClasspathEntry);
            }
            IFolder libsFolder = project.getFolder("libs");
            libsFolder.create(false, true, progressMonitor);
            ArrayList<IFile> externalLibs = new ArrayList<IFile>();
            for (File libFile : requiredLibs) {
                if (libFile == null || !libFile.exists()) continue;
                FileInputStream resourceAsStream = new FileInputStream(libFile);
                PluginHelper.createFile(libFile.getName(), (IContainer)libsFolder, resourceAsStream, progressMonitor);
                IFile file = libsFolder.getFile(libFile.getName());
                IPath path = file.getFullPath();
                classpathEntries.add(JavaCore.newLibraryEntry((IPath)path, (IPath)path, null, (boolean)true));
                externalLibs.add(file);
            }
            Path java11ContainerPath = new Path(String.valueOf(JavaRuntime.JRE_CONTAINER) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-11");
            classpathEntries.add(JavaCore.newContainerEntry((IPath)java11ContainerPath, null, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"module", (String)"true")}, (boolean)false));
            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
            javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), progressMonitor);
            javaProject.setOutputLocation((IPath)new Path("/" + adapterInfo.getProjectName() + "/bin"), progressMonitor);
            ProjectUtil.createJRClasspathContainer((IProgressMonitor)progressMonitor, (IJavaProject)javaProject);
            IFolder imagesFolder = project.getFolder("images");
            imagesFolder.create(false, true, progressMonitor);
            PluginHelper.createManifest(adapterInfo, requiredBundles, externalLibs, progressMonitor, project);
            PluginHelper.createBuildProps(progressMonitor, project, srcFolders);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JaspersoftStudioPlugin.getInstance().logError(exception);
        }
        return project;
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        PluginHelper.assertExist(file.getParent());
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            JaspersoftStudioPlugin.getInstance().logError(e);
        }
        progressMonitor.worked(1);
        return file;
    }

    public static IFile createFile(String path, IContainer container, InputStream inputStream, IProgressMonitor progressMonitor) {
        IFile file;
        block16: {
            file = container.getFile((IPath)new Path(path));
            try {
                try {
                    if (file.exists()) {
                        file.setContents(inputStream, true, true, progressMonitor);
                    } else {
                        file.create(inputStream, true, progressMonitor);
                    }
                    inputStream.close();
                }
                catch (Exception e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            JaspersoftStudioPlugin.getInstance().logError(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        JaspersoftStudioPlugin.getInstance().logError(e);
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
        }
        progressMonitor.worked(1);
        return file;
    }

    private static void createBuildProps(IProgressMonitor progressMonitor, IProject project, List<String> srcFolders) {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        Iterator<String> iterator = srcFolders.iterator();
        while (iterator.hasNext()) {
            bpContent.append(iterator.next()).append('/');
            if (!iterator.hasNext()) continue;
            bpContent.append(",");
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = plugin.xml,\\\n");
        bpContent.append("META-INF/,\\\n");
        bpContent.append("libs/,\\\n");
        bpContent.append("images/,\\\n");
        bpContent.append(".");
        PluginHelper.createFile("build.properties", (IContainer)project, bpContent.toString(), progressMonitor);
    }

    private static void createManifest(AdapterInfo adapterInfo, List<String> requiredBundles, List<IFile> externalLibs, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        StringBuilder maniContent = new StringBuilder("Manifest-Version: 1.0\n");
        maniContent.append("Bundle-ManifestVersion: 2\n");
        maniContent.append("Bundle-Name: " + adapterInfo.getProjectName() + "\n");
        maniContent.append("Bundle-SymbolicName: " + adapterInfo.getPluginId() + "; singleton:=true\n");
        maniContent.append("Bundle-Version: 1.0.0.qualifier\n");
        maniContent.append("Bundle-Activator: " + adapterInfo.getPackageName() + ".Activator\n");
        if (requiredBundles != null && !requiredBundles.isEmpty()) {
            maniContent.append("Require-Bundle: " + requiredBundles.get(0));
            int i = 1;
            while (i < requiredBundles.size()) {
                maniContent.append(",\n " + requiredBundles.get(i));
                ++i;
            }
            maniContent.append("\n");
        }
        maniContent.append("Bundle-ActivationPolicy: lazy\n");
        maniContent.append("Eclipse-BuddyPolicy: registered\n");
        maniContent.append("Eclipse-RegisterBuddy: com.jaspersoft.studio.data\n");
        maniContent.append("Bundle-RequiredExecutionEnvironment: JavaSE-11\r\n");
        if (!externalLibs.isEmpty()) {
            maniContent.append("Bundle-ClassPath: ");
            for (IFile lib : externalLibs) {
                String path = " libs/" + lib.getName();
                maniContent.append(String.valueOf(path) + ",\n");
            }
            maniContent.append(" .\n");
        }
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, progressMonitor);
        PluginHelper.createFile("MANIFEST.MF", (IContainer)metaInf, maniContent.toString(), progressMonitor);
    }

    private static void assertExist(IContainer c) {
        if (!c.exists()) {
            if (!c.getParent().exists()) {
                PluginHelper.assertExist(c.getParent());
            }
            if (c instanceof IFolder) {
                try {
                    ((IFolder)c).create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
        }
    }

    public static LoadedClassesContainer loadAndScanJar(File jarFile) throws ClassNotFoundException, ZipException, IOException {
        URLClassLoader loader = URLClassLoader.newInstance(new URL[]{jarFile.toURI().toURL()}, PluginHelper.class.getClassLoader());
        LoadedClassesContainer classes = new LoadedClassesContainer();
        try (JarFile jar = null;){
            jar = new JarFile(jarFile);
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().endsWith(".class")) continue;
                String className = zipEntry.getName();
                className = className.replace(".class", "").replace("/", ".");
                Class<?> clazz = loader.loadClass(className);
                try {
                    classes.addClass(clazz);
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
            }
        }
        return classes;
    }
}

