/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.controls;

import com.jaspersoft.studio.custom.adapter.controls.ElementValueDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CollectionInputDialog
extends PersistentLocationDialog {
    private TableViewer tableViewer;
    private String type;
    private List<Object> values;

    public CollectionInputDialog(Shell parentShell, List<Object> values, String elementType) {
        super(parentShell);
        this.type = elementType;
        this.values = values == null ? new ArrayList<Object>() : new ArrayList<Object>(values);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.CollectionInputDialog_dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(parent.getBackground());
        Button bnew = new Button(bGroup, 8);
        bnew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementValueDialog dialog = new ElementValueDialog(CollectionInputDialog.this.getShell(), null, CollectionInputDialog.this.type);
                if (dialog.open() == 0) {
                    CollectionInputDialog.this.values.add(dialog.getReturnValue());
                    CollectionInputDialog.this.tableViewer.refresh();
                }
            }
        });
        bnew.setText(Messages.common_add);
        bnew.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button editButton = new Button(bGroup, 8);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementValueDialog dialog;
                int index = CollectionInputDialog.this.tableViewer.getTable().getSelectionIndex();
                if (index != -1 && (dialog = new ElementValueDialog(CollectionInputDialog.this.getShell(), CollectionInputDialog.this.values.get(index).toString(), CollectionInputDialog.this.type)).open() == 0) {
                    CollectionInputDialog.this.values.set(index, dialog.getReturnValue());
                    CollectionInputDialog.this.tableViewer.refresh();
                }
            }
        });
        editButton.setText(Messages.common_edit);
        editButton.setEnabled(false);
        editButton.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button deleteButton = new Button(bGroup, 8);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CollectionInputDialog.this.tableViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    CollectionInputDialog.this.values.remove(index);
                    CollectionInputDialog.this.tableViewer.refresh();
                }
            }
        });
        deleteButton.setText(Messages.common_delete);
        deleteButton.setEnabled(false);
        deleteButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex = CollectionInputDialog.this.tableViewer.getTable().getSelectionIndex();
                deleteButton.setEnabled(selectionIndex != -1);
                editButton.setEnabled(selectionIndex != -1);
            }
        });
        this.tableViewer.setInput(this.values);
        return composite;
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 400;
        gd.minimumWidth = 400;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }

    public List<Object> getValues() {
        return this.values;
    }
}

