/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.controls;

import com.jaspersoft.studio.custom.adapter.controls.PropertyListControl;
import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.beanutils.BeanUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class DynamicControlComposite
extends ADataAdapterComposite {
    protected static final String TYPE_KEY = "type";
    protected static final String BIND_KEY = "bind";
    protected DataAdapterDescriptor dataAdapterDescriptor;
    protected List<Control> generatedControls = new ArrayList<Control>();

    protected DynamicControlComposite(Composite parent, int style, JasperReportsContext context) {
        super(parent, style, context);
        this.setLayout((Layout)new GridLayout(2, false));
    }

    protected String getXmlDefinitionLocation() {
        Properties props = new Properties();
        try {
            props.load(this.dataAdapterDescriptor.getClass().getResourceAsStream("/jasperreports_extension.properties"));
            for (Object property : props.keySet()) {
                if (!property.toString().startsWith("net.sf.jasperreports.extension.castor.mapping")) continue;
                return props.getProperty(property.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void createDynamicControl(String type, String bindName, String label) {
        if (type.equals("int")) {
            Label lbl = new Label((Composite)this, 0);
            lbl.setText(label);
            Spinner control = new Spinner((Composite)this, 2048);
            control.setData(BIND_KEY, (Object)bindName);
            control.setData(TYPE_KEY, (Object)type);
            control.setLayoutData((Object)new GridData(768));
            this.generatedControls.add((Control)control);
        } else if (type.equals("boolean")) {
            Label lbl = new Label((Composite)this, 0);
            lbl.setText(label);
            Button control = new Button((Composite)this, 32);
            control.setData(BIND_KEY, (Object)bindName);
            control.setData(TYPE_KEY, (Object)type);
            this.generatedControls.add((Control)control);
        } else if (type.equals("float")) {
            Label lbl = new Label((Composite)this, 0);
            lbl.setText(label);
            Text control = new Text((Composite)this, 2048);
            control.setData(BIND_KEY, (Object)bindName);
            control.setData(TYPE_KEY, (Object)type);
            control.setLayoutData((Object)new GridData(768));
            control.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Text text = (Text)e.getSource();
                    String oldS = text.getText();
                    String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                    boolean isFloat = true;
                    try {
                        Float.parseFloat(newS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        isFloat = false;
                    }
                    if (!isFloat) {
                        e.doit = false;
                    }
                }
            });
            this.generatedControls.add((Control)control);
        } else if (type.equals("string")) {
            Label lbl = new Label((Composite)this, 0);
            lbl.setText(label);
            Text control = new Text((Composite)this, 2048);
            control.setData(BIND_KEY, (Object)bindName);
            control.setData(TYPE_KEY, (Object)type);
            control.setLayoutData((Object)new GridData(768));
        }
    }

    protected void createDynamicArray(String type, String bindName, String label) {
        new Label((Composite)this, 0).setText(label);
        PropertyListControl listControl = new PropertyListControl(this, type);
        listControl.setData(BIND_KEY, bindName);
        listControl.setData(TYPE_KEY, "collection");
        listControl.setLayoutData(new GridData(768));
        this.generatedControls.add((Control)listControl);
    }

    private Node getBindNode(Node parent) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeName().equals("bind-xml")) {
                return child;
            }
            ++i;
        }
        return null;
    }

    protected void createDynamicControls(NodeList fieldNodes) {
        int i = 0;
        while (i < fieldNodes.getLength()) {
            String nameAttribute;
            Node fieldNode = fieldNodes.item(i);
            if (fieldNode.getNodeName().equals("field") && !(nameAttribute = fieldNode.getAttributes().getNamedItem("name").getNodeValue()).equals("class") && !nameAttribute.equals("name")) {
                String type = fieldNode.getAttributes().getNamedItem(TYPE_KEY).getNodeValue();
                Node collectionNode = fieldNode.getAttributes().getNamedItem("collection");
                boolean isArray = collectionNode != null && collectionNode.getNodeValue().toLowerCase().equals("arraylist");
                Node bindNode = this.getBindNode(fieldNode);
                if (bindNode != null) {
                    String name = fieldNode.getAttributes().getNamedItem("name").getNodeValue();
                    String bindName = bindNode.getAttributes().getNamedItem("name").getNodeValue();
                    if (isArray) {
                        this.createDynamicArray(type, bindName, name);
                    } else {
                        this.createDynamicControl(type, bindName, name);
                    }
                }
            }
            ++i;
        }
    }

    protected void createDynamicControls() {
        String xmlDefinition = this.getXmlDefinitionLocation();
        if (xmlDefinition != null) {
            DataAdapter adapter = this.dataAdapterDescriptor.getDataAdapter();
            InputStream is = this.dataAdapterDescriptor.getClass().getResourceAsStream("/" + xmlDefinition);
            if (is != null) {
                try {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setValidating(false);
                    dbf.setIgnoringComments(true);
                    dbf.setNamespaceAware(false);
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    builder.setEntityResolver(new EntityResolver(){

                        @Override
                        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                            if (systemId.contains("http://castor.org/mapping.dtd")) {
                                return new InputSource(new StringReader(""));
                            }
                            return null;
                        }
                    });
                    Document document = builder.parse(is);
                    Element mapNode = document.getDocumentElement();
                    if (mapNode.getNodeName().equals("mapping")) {
                        NodeList adapterNodes = mapNode.getChildNodes();
                        int j = 0;
                        while (j < adapterNodes.getLength()) {
                            String classAttribute;
                            Node adapterNode = adapterNodes.item(j);
                            if (adapterNode.getNodeName().equals("class") && (classAttribute = adapterNode.getAttributes().getNamedItem("name").getNodeValue()) != null && classAttribute.equals(adapter.getClass().getName())) {
                                this.createDynamicControls(adapterNode.getChildNodes());
                                is.close();
                                return;
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception ex) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ex.printStackTrace();
                }
            }
        }
    }

    protected void initComponents() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.generatedControls.clear();
        this.createDynamicControls();
    }

    @Override
    public void setDataAdapter(DataAdapterDescriptor dataAdapterDescriptor) {
        this.dataAdapterDescriptor = dataAdapterDescriptor;
        DataAdapter dataAdapter = dataAdapterDescriptor.getDataAdapter();
        this.initComponents();
        this.bindWidgets(dataAdapter);
    }

    protected void updateAdapterSettings(DataAdapter dataAdapter) {
        for (Control control : this.generatedControls) {
            String methodName = (String)control.getData(BIND_KEY);
            String type = (String)control.getData(TYPE_KEY);
            try {
                Text text;
                if (type.equals("string")) {
                    text = (Text)control;
                    BeanUtils.setProperty((Object)dataAdapter, (String)methodName, (Object)text.getText());
                    continue;
                }
                if (type.equals("float")) {
                    text = (Text)control;
                    BeanUtils.setProperty((Object)dataAdapter, (String)methodName, (Object)text.getText());
                    continue;
                }
                if (type.equals("int")) {
                    Spinner spinner = (Spinner)control;
                    BeanUtils.setProperty((Object)dataAdapter, (String)methodName, (Object)String.valueOf(spinner.getSelection()));
                    continue;
                }
                if (!type.equals("boolean")) continue;
                Button button = (Button)control;
                BeanUtils.setProperty((Object)dataAdapter, (String)methodName, (Object)String.valueOf(button.getSelection()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    protected void bindWidgets(DataAdapter dataAdapter) {
        final DataAdapter adapter = dataAdapter;
        ModifyListener valueChangedListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DynamicControlComposite.this.updateAdapterSettings(adapter);
            }
        };
        SelectionAdapter buttonChangedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicControlComposite.this.updateAdapterSettings(adapter);
            }
        };
        for (Control control : this.generatedControls) {
            String methodName = (String)control.getData(BIND_KEY);
            String type = (String)control.getData(TYPE_KEY);
            try {
                String result = BeanUtils.getProperty((Object)adapter, (String)methodName);
                if (type.equals("string") || type.equals("float")) {
                    Text text = (Text)control;
                    text.setText(result != null ? result : "");
                    text.addModifyListener(valueChangedListener);
                    continue;
                }
                if (type.equals("int")) {
                    Spinner spinner = (Spinner)control;
                    if (result != null) {
                        spinner.setSelection(Integer.parseInt(result));
                    }
                    spinner.addModifyListener(valueChangedListener);
                    continue;
                }
                if (!type.equals("boolean")) continue;
                Button button = (Button)control;
                if (result != null) {
                    button.setSelection(Boolean.parseBoolean(result));
                }
                button.addSelectionListener((SelectionListener)buttonChangedListener);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

