/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.controls;

import com.jaspersoft.studio.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ElementValueDialog
extends PersistentLocationDialog {
    private String type;
    private String previousValue;
    private String newValue;
    private Control createdControl;

    public ElementValueDialog(Shell parentShell, String previousValue, String type) {
        super(parentShell);
        this.type = type;
        this.previousValue = previousValue;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.previousValue != null) {
            shell.setText(Messages.ElementValueDialog_editText);
        } else {
            shell.setText(Messages.ElementValueDialog_newText);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        if (this.type.equals("int")) {
            Spinner control = new Spinner(composite, 2048);
            control.setLayoutData((Object)new GridData(768));
            this.createdControl = control;
            if (this.previousValue != null) {
                control.setSelection(Integer.parseInt(this.previousValue));
            }
        } else if (this.type.equals("boolean")) {
            Combo control = new Combo(parent, 2056);
            control.setItems(new String[]{"true", "false"});
            this.createdControl = control;
            if (this.previousValue != null) {
                control.select(Boolean.parseBoolean(this.previousValue) ? 0 : 1);
            }
        } else if (this.type.equals("float")) {
            Text control = new Text(composite, 2048);
            control.setLayoutData((Object)new GridData(768));
            this.createdControl = control;
            control.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Text text = (Text)e.getSource();
                    String oldS = text.getText();
                    String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                    boolean isFloat = true;
                    try {
                        Float.parseFloat(newS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        isFloat = false;
                    }
                    if (!isFloat) {
                        e.doit = false;
                    }
                }
            });
            if (this.previousValue != null) {
                control.setText(this.previousValue);
            }
        } else if (this.type.equals("string")) {
            Text control = new Text(composite, 2048);
            control.setLayoutData((Object)new GridData(768));
            this.createdControl = control;
            if (this.previousValue != null) {
                control.setText(this.previousValue);
            }
        }
        return composite;
    }

    protected void okPressed() {
        if (this.type.equals("float") || this.type.equals("string")) {
            this.newValue = ((Text)this.createdControl).getText();
        } else if (this.type.equals("int")) {
            this.newValue = String.valueOf(((Spinner)this.createdControl).getSelection());
        } else if (this.type.equals("boolean")) {
            Combo combo = (Combo)this.createdControl;
            this.newValue = Boolean.toString(combo.getSelectionIndex() == 0);
        }
        super.okPressed();
    }

    public String getReturnValue() {
        return this.newValue;
    }
}

