/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.wizard;

import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.editor.table.TableLabelProvider;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AdditionalJarsPage
extends JSSHelpWizardPage {
    private TableViewer tableViewer;
    private List<String> jarPaths;

    public AdditionalJarsPage() {
        super("additionaljarpage");
        this.setTitle(Messages.AdditionalJarsPage_wizardTitle);
        this.setDescription(Messages.AdditionalJarsPage_wizardDescription);
        this.jarPaths = new ArrayList<String>();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.buildTable(composite);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        bGroup.setBackground(parent.getBackground());
        Button bnew = new Button(bGroup, 8);
        bnew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(AdditionalJarsPage.this.getShell(), 4098);
                fd.setText(Messages.common_open);
                String[] filterExt = new String[]{"*.jar"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    String[] fileNames = fd.getFileNames();
                    File parentFolder = new File(selected).getParentFile();
                    String[] stringArray = fileNames;
                    int n = fileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        File actualFile = new File(parentFolder, fileName);
                        selected = actualFile.getAbsolutePath();
                        if (actualFile.exists() && actualFile.isFile() && !AdditionalJarsPage.this.jarPaths.contains(selected)) {
                            AdditionalJarsPage.this.jarPaths.add(selected);
                        }
                        ++n2;
                    }
                    AdditionalJarsPage.this.tableViewer.refresh();
                }
            }
        });
        bnew.setText(Messages.common_add);
        bnew.setLayoutData((Object)new GridData(4, 128, false, false));
        final Button deleteButton = new Button(bGroup, 8);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AdditionalJarsPage.this.tableViewer.getTable().getSelectionIndex();
                if (index != -1) {
                    AdditionalJarsPage.this.jarPaths.remove(index);
                    AdditionalJarsPage.this.tableViewer.refresh();
                }
            }
        });
        deleteButton.setText(Messages.common_delete);
        deleteButton.setEnabled(false);
        deleteButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex = AdditionalJarsPage.this.tableViewer.getTable().getSelectionIndex();
                deleteButton.setEnabled(selectionIndex != -1);
            }
        });
        this.tableViewer.setInput(this.jarPaths);
        this.setControl((Control)composite);
    }

    @Override
    protected String getContextName() {
        return null;
    }

    private void buildTable(Composite composite) {
        Table table = new Table(composite, 67586);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 300;
        gd.minimumWidth = 400;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer = new TableViewer(table);
        this.attachContentProvider(this.tableViewer);
        this.attachLabelProvider(this.tableViewer);
        TableColumn[] column = new TableColumn[]{new TableColumn(table, 0)};
        column[0].setText(Messages.AdditionalJarsPage_columnTitle);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachLabelProvider(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private void attachContentProvider(TableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
    }

    public List<String> getValues() {
        if (this.jarPaths == null) {
            this.jarPaths = new ArrayList<String>();
        }
        return this.jarPaths;
    }
}

