/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.wizard;

import com.jaspersoft.studio.custom.adapter.AdapterInfo;
import com.jaspersoft.studio.custom.adapter.LoadedClassesContainer;
import com.jaspersoft.studio.custom.adapter.Pair;
import com.jaspersoft.studio.custom.adapter.PluginHelper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CustomJarInformationPage
extends JSSHelpWizardPage {
    private String jarPath = null;
    private Combo adapterInterfaceCombo;
    private Combo adapterImplementationCombo;
    private Combo adapterServiceCombo;
    private Combo adapterServiceFactoryCombo;
    private Pair adapterInterface;
    private Pair adapterImplementation;
    private Pair adapterService;
    private Pair adapterServiceFactory;
    private boolean generateDynamicControls = false;

    protected CustomJarInformationPage() {
        super("dataadapterselectionpage");
        this.setTitle(Messages.CustomJarInformationPage_title);
        this.setDescription(Messages.CustomJarInformationPage_description);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createPathControls(composite);
        this.createClassesControls(composite);
        this.createCompositeControls(composite);
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    private void createCompositeControls(Composite parent) {
        Button compositeButton = new Button(parent, 32);
        compositeButton.setText(Messages.CustomJarInformationPage_automaticComposite);
        compositeButton.setSelection(false);
        compositeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomJarInformationPage.this.generateDynamicControls = ((Button)e.getSource()).getSelection();
            }
        });
    }

    private void createPathControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        container.setLayout((Layout)new GridLayout(3, false));
        Label jarPathLabel = new Label(container, 0);
        jarPathLabel.setText(Messages.CustomJarInformationPage_pathLabel);
        final Text jarPathText = new Text(container, 2048);
        jarPathText.setLayoutData((Object)new GridData(768));
        jarPathText.setEditable(false);
        Button browseButton = new Button(container, 0);
        browseButton.setText(Messages.common_browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(CustomJarInformationPage.this.getShell(), 4096);
                fd.setText(Messages.common_open);
                String[] filterExt = new String[]{"*.jar"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    jarPathText.setText(selected);
                    CustomJarInformationPage.this.jarPath = selected;
                    CustomJarInformationPage.this.updateField();
                }
            }
        });
    }

    private void createClassesControls(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        container.setLayout((Layout)new GridLayout(1, true));
        Composite leftColumn = new Composite(container, 0);
        leftColumn.setLayoutData((Object)new GridData(1808));
        leftColumn.setLayout((Layout)new GridLayout(2, false));
        Label adapterInterfaceLabel = new Label(leftColumn, 0);
        adapterInterfaceLabel.setText(Messages.CustomJarInformationPage_interfaceLabel);
        this.adapterInterfaceCombo = new Combo(leftColumn, 2048);
        this.adapterInterfaceCombo.setLayoutData((Object)new GridData(768));
        Label adapterImplementationLabel = new Label(leftColumn, 0);
        adapterImplementationLabel.setText(Messages.CustomJarInformationPage_implementationLabel);
        this.adapterImplementationCombo = new Combo(leftColumn, 2048);
        this.adapterImplementationCombo.setLayoutData((Object)new GridData(768));
        Label adapterServiceLabel = new Label(leftColumn, 0);
        adapterServiceLabel.setText(Messages.CustomJarInformationPage_serviceLabel);
        this.adapterServiceCombo = new Combo(leftColumn, 2048);
        this.adapterServiceCombo.setLayoutData((Object)new GridData(768));
        Label adapterServiceFactoryLabel = new Label(leftColumn, 0);
        adapterServiceFactoryLabel.setText(Messages.CustomJarInformationPage_serviceFactoryLabel);
        this.adapterServiceFactoryCombo = new Combo(leftColumn, 2048);
        this.adapterServiceFactoryCombo.setLayoutData((Object)new GridData(768));
        ModifyListener comboModified = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CustomJarInformationPage.this.storeValues();
            }
        };
        this.adapterServiceFactoryCombo.addModifyListener(comboModified);
        this.adapterInterfaceCombo.addModifyListener(comboModified);
        this.adapterServiceCombo.addModifyListener(comboModified);
        this.adapterImplementationCombo.addModifyListener(comboModified);
    }

    private void updateField() {
        File jarFile = new File(this.jarPath);
        if (jarFile.exists()) {
            try {
                LoadedClassesContainer loadedClasses = PluginHelper.loadAndScanJar(jarFile);
                String[] implementations = LoadedClassesContainer.converToArray(loadedClasses.getAdapterImplementation());
                String[] services = LoadedClassesContainer.converToArray(loadedClasses.getService());
                String[] factories = LoadedClassesContainer.converToArray(loadedClasses.getServiceFatory());
                ArrayList<Pair> validInterfaces = new ArrayList<Pair>();
                validInterfaces.addAll(loadedClasses.getAdapterInterfaces());
                validInterfaces.addAll(loadedClasses.getAdapterImplementation());
                String[] interfaces = LoadedClassesContainer.converToArray(validInterfaces);
                this.adapterInterfaceCombo.setItems(interfaces);
                this.adapterImplementationCombo.setItems(implementations);
                this.adapterServiceCombo.setItems(services);
                this.adapterServiceFactoryCombo.setItems(factories);
                if (interfaces.length > 0) {
                    this.adapterInterfaceCombo.select(0);
                }
                if (implementations.length > 0) {
                    this.adapterImplementationCombo.select(0);
                }
                if (services.length > 0) {
                    this.adapterServiceCombo.select(0);
                }
                if (factories.length > 0) {
                    this.adapterServiceFactoryCombo.select(0);
                }
                this.setPageComplete(interfaces.length > 0 && implementations.length > 0 && services.length > 0 && factories.length > 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setPageComplete(false);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    private void storeValues() {
        this.adapterInterface = LoadedClassesContainer.convertToPair(this.adapterInterfaceCombo.getText());
        this.adapterImplementation = LoadedClassesContainer.convertToPair(this.adapterImplementationCombo.getText());
        this.adapterService = LoadedClassesContainer.convertToPair(this.adapterServiceCombo.getText());
        this.adapterServiceFactory = LoadedClassesContainer.convertToPair(this.adapterServiceFactoryCombo.getText());
    }

    @Override
    protected String getContextName() {
        return null;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setCustomAdapterInfo(AdapterInfo info) {
        info.setDataAdapterInterface(this.adapterInterface);
        info.setDataAdapterService(this.adapterService);
        info.setDataAdapterImplementation(this.adapterImplementation);
        info.setDataAdapterServiceFactory(this.adapterServiceFactory);
    }

    public boolean createDynamicControls() {
        return this.generateDynamicControls;
    }
}

