/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.QueryStatus;
import com.jaspersoft.studio.data.ui.SimpleQueryWizardDataEditorComposite;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ATreeWizardDataEditorComposite
extends SimpleQueryWizardDataEditorComposite {
    protected StyledText queryTextArea;
    protected TreeViewer treeViewer;
    protected boolean isRefreshing;
    private QueryStatus qStatus;

    public ATreeWizardDataEditorComposite(Composite parent, WizardPage page, DataAdapterDescriptor dataAdapterDescriptor) {
        super(parent, page, dataAdapterDescriptor);
    }

    @Override
    protected void createCompositeContent() {
        GridLayout cmpGl = new GridLayout(1, true);
        cmpGl.marginWidth = 0;
        cmpGl.marginHeight = 0;
        this.setLayout((Layout)cmpGl);
        Label title = new Label((Composite)this, 0);
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        title.setText(this.getTitle());
        SashForm sashForm = new SashForm((Composite)this, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeViewer((Composite)sashForm);
        this.createQueryTextArea((Composite)sashForm);
        this.qStatus = new QueryStatus(this);
        sashForm.setWeights(new int[]{30, 70});
        this.refreshTreeViewerContent(this.getDataAdapterDescriptor());
    }

    protected void createQueryTextArea(Composite parent) {
        this.queryTextArea = new StyledText(parent, 2048);
        this.queryTextArea.setFont(FontUtils.getEditorsFont(this.getJasperReportsConfiguration()));
        this.queryTextArea.addModifyListener(e -> this.queryTextAreaModified());
    }

    protected void createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider(this.getTreeContentProvider());
        this.treeViewer.setLabelProvider(this.getTreeLabelProvider());
    }

    protected void queryTextAreaModified() {
        this.setQueryString(this.queryTextArea.getText());
        this.decorateTreeUsingQueryText();
    }

    protected void decorateTreeUsingQueryText() {
    }

    @Override
    public String getTitle() {
        return Messages.ATreeWizardDataEditorComposite_Title;
    }

    protected abstract IBaseLabelProvider getTreeLabelProvider();

    protected abstract IContentProvider getTreeContentProvider();

    protected abstract void refreshTreeViewerContent(DataAdapterDescriptor var1);

    protected QueryStatus getStatusBar() {
        return this.qStatus;
    }
}

