/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterEditor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.NameComposite;
import com.jaspersoft.studio.data.storage.FileDataAdapterStorage;
import com.jaspersoft.studio.editor.preview.ABasicEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.property.dataset.dialog.RunWithProgressBar;
import com.jaspersoft.studio.utils.jobs.CheckedRunnableWithProgress;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.builder.Markers;
import net.sf.jasperreports.eclipse.classpath.JavaProjectClassLoader;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;

public class DataAdapterEditorPart
extends ABasicEditor {
    public static final String ID = "com.jaspersoft.studio.data.DataAdapterEditorPart";
    private DataAdapterDescriptor descriptor;
    private ModelPropertyChangeListener modelListener = new ModelPropertyChangeListener();
    private NameComposite nameComposite;
    private ADataAdapterComposite dacomposite;

    public DataAdapterEditorPart() {
        super(true);
    }

    @Override
    protected void setInput(IEditorInput input) {
        block6: {
            super.setInput(input);
            InputStream in = null;
            try {
                try {
                    IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                    in = file.getContents(true);
                    this.descriptor = FileDataAdapterStorage.readDataADapter(in, file, this.jrContext);
                    if (this.descriptor == null) {
                        throw new PartInitException("Can't find DataAdapter mapping.");
                    }
                }
                catch (CoreException e) {
                    UIUtils.showError((Throwable)e);
                    FileUtils.closeStream(in);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                FileUtils.closeStream(in);
                throw throwable;
            }
            FileUtils.closeStream((Closeable)in);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            this.descriptor = this.dacomposite.getDataAdapter();
            this.dacomposite.performAdditionalUpdates();
            String xml = DataAdapterManager.toDataAdapterFile(this.descriptor, (JasperReportsContext)this.jrContext);
            file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), 3, monitor);
            Markers.deleteMarkers((IResource)file);
        }
        catch (CoreException e) {
            UIUtils.showError((Throwable)e);
        }
        this.isDirty = false;
        this.firePropertyChange(257);
    }

    @Override
    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(((FileEditorInput)this.getEditorInput()).getFile());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            IProgressMonitor monitor = this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            try {
                String xml = DataAdapterManager.toDataAdapterFile(this.descriptor, (JasperReportsContext)this.jrContext);
                file.create((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), true, monitor);
                FileEditorInput modelFile = new FileEditorInput(file);
                this.setInputWithNotify((IEditorInput)modelFile);
                this.setInput((IEditorInput)modelFile);
                this.setPartName(file.getName());
                this.doSave(monitor);
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.nameComposite = new NameComposite(c, 0, (JasperReportsContext)this.jrContext);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.nameComposite.setLayoutData(gd);
        if (this.descriptor != null) {
            DataAdapterEditor editor = this.descriptor.getEditor();
            this.dacomposite = editor.getComposite(c, 0, null, (JasperReportsContext)this.jrContext);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, editor.getHelpContextId());
            this.nameComposite.addModifyListener(this.modelListener);
            this.dacomposite.addModifyListener(this.modelListener);
            gd = new GridData(1808);
            gd.horizontalSpan = 2;
            this.dacomposite.setLayoutData(gd);
            editor.setDataAdapter(this.descriptor);
            this.nameComposite.setDataAdapter(this.descriptor);
            final Button btnTest = new Button(c, 8);
            btnTest.setText(Messages.DataAdapterEditorPart_testButton);
            Composite cmp = new Composite(c, 0);
            cmp.setLayout((Layout)new GridLayout(2, false));
            cmp.setLayoutData((Object)new GridData(768));
            final RunWithProgressBar runner = new RunWithProgressBar(cmp);
            gd = new GridData(768);
            gd.heightHint = 20;
            runner.getProgressBar().setLayoutData((Object)gd);
            final DataAdapterService das = DataAdapterServiceUtil.getInstance((ParameterContributorContext)new ParameterContributorContext((JasperReportsContext)this.jrContext, null, null)).getService(editor.getDataAdapter().getDataAdapter());
            btnTest.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        runner.run(false, true, new CheckedRunnableWithProgress(){

                            @Override
                            protected void runOperations(IProgressMonitor monitor) {
                                block6: {
                                    UIUtils.getDisplay().syncExec(() -> btnTest.setEnabled(false));
                                    monitor.beginTask(Messages.DataAdapterEditorPart_0, -1);
                                    ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                                    try {
                                        try {
                                            ClassLoader cl;
                                            IProject project = ((IFileEditorInput)DataAdapterEditorPart.this.getEditorInput()).getFile().getProject();
                                            if (project.hasNature("org.eclipse.jdt.core.javanature") && (cl = JavaProjectClassLoader.instance((IJavaProject)JavaCore.create((IProject)project))) != null) {
                                                Thread.currentThread().setContextClassLoader(cl);
                                            }
                                            das.test();
                                            UIUtils.getDisplay().syncExec(() -> {
                                                MessageBox mb = new MessageBox(btnTest.getShell(), 34);
                                                mb.setText(Messages.DataAdapterWizard_testbutton);
                                                mb.setMessage(Messages.DataAdapterWizard_testsuccesful);
                                                mb.open();
                                            });
                                        }
                                        catch (Exception e1) {
                                            UIUtils.showError((Throwable)e1);
                                            Thread.currentThread().setContextClassLoader(oldCL);
                                            UIUtils.getDisplay().syncExec(() -> btnTest.setEnabled(true));
                                            break block6;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Thread.currentThread().setContextClassLoader(oldCL);
                                        UIUtils.getDisplay().syncExec(() -> btnTest.setEnabled(true));
                                        throw throwable;
                                    }
                                    Thread.currentThread().setContextClassLoader(oldCL);
                                    UIUtils.getDisplay().syncExec(() -> btnTest.setEnabled(true));
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        UIUtils.showError((Throwable)e1.getTargetException());
                    }
                    catch (InterruptedException e1) {
                        UIUtils.showError((Throwable)e1);
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.nameComposite.setFocus();
    }

    private final class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private ModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataAdapterEditorPart.this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> {
                DataAdapterEditorPart.this.isDirty = true;
                DataAdapterEditorPart.this.firePropertyChange(257);
            });
        }
    }
}

