/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.actions.CreateDataAdapterAction;
import com.jaspersoft.studio.data.actions.DeleteDataAdapterAction;
import com.jaspersoft.studio.data.actions.DuplicateDataAdapterAction;
import com.jaspersoft.studio.data.actions.EditDataAdapterAction;
import com.jaspersoft.studio.data.actions.ExportDataAdapterAction;
import com.jaspersoft.studio.data.actions.ImportDataAdapterAction;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.dnd.DataAdapterDragSourceListener;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.repository.IRepositoryViewProvider;
import com.jaspersoft.studio.repository.actions.Separator;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;

public class DataAdapterProvider
implements IRepositoryViewProvider {
    private CreateDataAdapterAction createDataAdapterItemAction;
    private EditDataAdapterAction editDataAdapterItemAction;
    private DeleteDataAdapterAction deleteDataAdapterItemAction;
    private DuplicateDataAdapterAction duplicateDataAdapterItemAction;
    private ExportDataAdapterAction exportDataAdapterItemAction;
    private ImportDataAdapterAction importDataAdapterItemAction;
    private List<ADataAdapterStorage> storages = new ArrayList<ADataAdapterStorage>();

    @Override
    public Action[] getActions(TreeViewer treeViewer) {
        this.createActions(treeViewer);
        return new Action[]{this.createDataAdapterItemAction};
    }

    private void createActions(TreeViewer treeViewer) {
        if (this.createDataAdapterItemAction == null) {
            this.createDataAdapterItemAction = new CreateDataAdapterAction(treeViewer);
        }
        if (this.editDataAdapterItemAction == null) {
            this.editDataAdapterItemAction = new EditDataAdapterAction(treeViewer);
        }
        if (this.deleteDataAdapterItemAction == null) {
            this.deleteDataAdapterItemAction = new DeleteDataAdapterAction(treeViewer);
        }
        if (this.duplicateDataAdapterItemAction == null) {
            this.duplicateDataAdapterItemAction = new DuplicateDataAdapterAction(treeViewer);
        }
        if (this.exportDataAdapterItemAction == null) {
            this.exportDataAdapterItemAction = new ExportDataAdapterAction(treeViewer);
        }
        if (this.importDataAdapterItemAction == null) {
            this.importDataAdapterItemAction = new ImportDataAdapterAction(treeViewer);
        }
    }

    @Override
    public List<IAction> fillContextMenu(TreeViewer treeViewer, ANode node) {
        this.createActions(treeViewer);
        ArrayList<IAction> lst = new ArrayList<IAction>();
        if (node instanceof MDataAdapters) {
            if (this.createDataAdapterItemAction.isEnabled()) {
                lst.add((IAction)this.createDataAdapterItemAction);
            }
            lst.add((IAction)new Separator());
        } else if (node instanceof MDataAdapter) {
            if (this.editDataAdapterItemAction.isEnabled()) {
                lst.add((IAction)this.editDataAdapterItemAction);
            }
            if (this.duplicateDataAdapterItemAction.isEnabled()) {
                lst.add((IAction)this.duplicateDataAdapterItemAction);
            }
            if (this.deleteDataAdapterItemAction.isEnabled()) {
                lst.add((IAction)this.deleteDataAdapterItemAction);
            }
            lst.add((IAction)new Separator());
            if (this.exportDataAdapterItemAction.isEnabled()) {
                lst.add((IAction)this.exportDataAdapterItemAction);
            }
        }
        if (this.importDataAdapterItemAction.isEnabled()) {
            lst.add((IAction)this.importDataAdapterItemAction);
        }
        return lst;
    }

    private boolean isMacDelete(KeyEvent event) {
        return Util.isMac() && event.character == '\b';
    }

    @Override
    public void hookKeyEvent(TreeViewer treeViewer, KeyEvent event) {
        if ((event.character == '\u007f' || this.isMacDelete(event)) && event.stateMask == 0 && this.deleteDataAdapterItemAction.isEnabled()) {
            this.deleteDataAdapterItemAction.run();
        }
    }

    @Override
    public void doubleClick(TreeViewer treeViewer) {
        this.editDataAdapterItemAction.run();
    }

    @Override
    public ANode getNode(ANode root) {
        ADataAdapterStorage s = DataAdapterManager.getPreferencesStorage();
        this.storages.add(s);
        return new MDataAdapters(root, s);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        for (ADataAdapterStorage ds : this.storages) {
            ds.addPropertyChangeListener(pcl);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        for (ADataAdapterStorage ds : this.storages) {
            ds.removePropertyChangeListener(pcl);
        }
    }

    @Override
    public void handleTreeEvent(TreeExpansionEvent event) {
    }

    @Override
    public List<TransferDragSourceListener> getTransferDragSourceListeners(TreeViewer treeViewer) {
        ArrayList<TransferDragSourceListener> dragListeners = new ArrayList<TransferDragSourceListener>(1);
        dragListeners.add(new DataAdapterDragSourceListener());
        return dragListeners;
    }

    @Override
    public List<TransferDropTargetListener> getTransferDropTargetListeners(TreeViewer treeViewer) {
        return new ArrayList<TransferDropTargetListener>(0);
    }

    @Override
    public List<Command> dropResource(String key, INode root) throws InterruptedException {
        return null;
    }
}

