/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.model.util.NodeIconDescriptor;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;

public class MDataAdapters
extends ANode {
    public static final long serialVersionUID = 10200L;
    private static final Comparator<INode> adapterComparator = new Comparator<INode>(){

        @Override
        public int compare(INode o1, INode o2) {
            DataAdapterDescriptor d1 = (DataAdapterDescriptor)o1.getValue();
            DataAdapterDescriptor d2 = (DataAdapterDescriptor)o2.getValue();
            return d1.getName().toLowerCase().compareTo(d2.getName().toLowerCase());
        }
    };
    private static IIconDescriptor iconDescriptor;
    private transient ADataAdapterStorage storage;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("DATAADAPTERS".equals(evt.getPropertyName())) {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                boolean exists = false;
                for (INode n : this.getChildren()) {
                    if (n.getValue() != evt.getNewValue()) continue;
                    exists = true;
                    break;
                }
                if (!exists) {
                    new MDataAdapter(this, (DataAdapterDescriptor)evt.getNewValue());
                    Collections.sort(this.getChildren(), adapterComparator);
                }
            }
            if (evt.getOldValue() != null) {
                for (INode n : this.getChildren()) {
                    MDataAdapter m = (MDataAdapter)n;
                    if (m.getValue() != evt.getOldValue()) continue;
                    this.removeChild(m);
                    break;
                }
            }
        }
        super.propertyChange(evt);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new NodeIconDescriptor("dataAdapters");
        }
        return iconDescriptor;
    }

    public MDataAdapters(ANode parent, ADataAdapterStorage storage) {
        super(parent, -1);
        this.storage = storage;
        storage.addPropertyChangeListener(this);
        storage.getDataAdapterDescriptors();
        for (DataAdapterDescriptor dad : storage.getDataAdapterDescriptors()) {
            new MDataAdapter(this, dad);
        }
        Collections.sort(this.getChildren(), adapterComparator);
    }

    @Override
    public ADataAdapterStorage getValue() {
        return this.storage;
    }

    @Override
    public String getDisplayText() {
        return MDataAdapters.getIconDescriptor().getTitle();
    }

    @Override
    public ImageDescriptor getImagePath() {
        return MDataAdapters.getIconDescriptor().getIcon16();
    }

    @Override
    public String getToolTip() {
        return MDataAdapters.getIconDescriptor().getToolTip();
    }
}

