/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.actions;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.data.MDataAdapters;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.wizard.DataAdapterWizard;
import com.jaspersoft.studio.data.wizard.DataAdapterWizardDialog;
import com.jaspersoft.studio.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class CreateDataAdapterAction
extends Action
implements ICheatSheetAction {
    public static final String ID = "createdataAdapteraction";
    private TreeViewer treeViewer;
    private DataAdapterDescriptor newDataAdapter;

    public CreateDataAdapterAction() {
        this(null);
    }

    public CreateDataAdapterAction(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.setId(ID);
        this.setText(Messages.CreateDataAdapterAction_actionName);
        this.setDescription(Messages.CreateDataAdapterAction_actionDescription);
        this.setToolTipText(Messages.CreateDataAdapterAction_actionToolTip);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/data_source_add.png"));
        this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/data_source_add.png"));
    }

    public void run() {
        TreeSelection s;
        TreePath[] p;
        int i;
        ADataAdapterStorage storage = null;
        if (this.treeViewer != null && (i = 0) < (p = (s = (TreeSelection)this.treeViewer.getSelection()).getPaths()).length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof MDataAdapters) {
                storage = ((MDataAdapters)obj).getValue();
            } else if (obj instanceof MDataAdapter) {
                storage = ((MDataAdapters)((MDataAdapter)obj).getParent()).getValue();
            }
        }
        if (storage == null) {
            storage = DataAdapterManager.getPreferencesStorage();
        }
        DataAdapterWizard wizard = new DataAdapterWizard(storage);
        DataAdapterWizardDialog dialog = new DataAdapterWizardDialog(UIUtils.getShell(), (IWizard)wizard);
        wizard.setWizardDialog(dialog);
        dialog.create();
        if (dialog.open() == 0) {
            this.newDataAdapter = wizard.getDataAdapter();
            DataAdapterManager.getPreferencesStorage().addDataAdapter(this.newDataAdapter);
            JaspersoftStudioPlugin.getInstance().getUsageManager().audit(this.newDataAdapter.getClass().getName(), "DataAdapter");
        }
    }

    public DataAdapterDescriptor getNewDataAdapter() {
        return this.newDataAdapter;
    }

    public void run(String[] params, ICheatSheetManager manager) {
        this.run();
        this.notifyResult(true);
    }
}

