/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.actions;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportDataAdapterAction
extends Action {
    public static final String ID = "exportDataAdapteraction";
    private TreeViewer treeViewer;

    public ExportDataAdapterAction(TreeViewer treeViewer) {
        this.setId(ID);
        this.treeViewer = treeViewer;
        this.setText(Messages.ExportDataAdapterAction_exportName);
        this.setDescription(Messages.ExportDataAdapterAction_exportDescription);
        this.setToolTipText(Messages.ExportDataAdapterAction_exportTooltip);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/export_wiz.gif"));
        this.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/export_wiz.gif"));
    }

    public boolean isEnabled() {
        Object firstElement = ((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
        return firstElement != null && firstElement instanceof MDataAdapter;
    }

    public void run() {
        TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
        TreePath[] p = s.getPaths();
        int i = 0;
        while (i < p.length) {
            Object obj = p[i].getLastSegment();
            if (obj instanceof MDataAdapter) {
                SaveAsDialog saveAsDialog = new SaveAsDialog(UIUtils.getShell());
                saveAsDialog.setOriginalName(String.valueOf(((MDataAdapter)obj).getValue().getName().replace(" ", "")) + ".jrdax");
                saveAsDialog.open();
                IPath path = saveAsDialog.getResult();
                if (path != null) {
                    this.saveFile(obj, path);
                }
            }
            ++i;
        }
    }

    private void saveFile(final Object obj, IPath path) {
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file != null) {
            ProgressMonitorDialog pm = new ProgressMonitorDialog(UIUtils.getShell());
            try {
                pm.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        JasperReportsConfiguration jConf = JasperReportsConfiguration.getDefaultJRConfig(file);
                        try {
                            try {
                                DataAdapterDescriptor m = ((MDataAdapter)obj).getValue();
                                String xml = DataAdapterManager.toDataAdapterFile(m, (JasperReportsContext)jConf);
                                if (file.exists()) {
                                    file.setContents((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), true, true, monitor);
                                } else {
                                    file.create((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), true, monitor);
                                }
                                IDE.setDefaultEditor((IFile)file, (String)"com.jaspersoft.studio.data.DataAdapterEditorPart");
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            jConf.dispose();
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                UIUtils.showError((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }
}

