/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.adapter;

import com.jaspersoft.studio.data.adapter.ImportUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class IReportDescriptor {
    protected File destination;
    protected String version;
    private boolean isPro;
    private static final String PRO_STRING = "Pro";
    protected Properties configurationProperties = null;
    protected Properties serverProperties = null;

    public IReportDescriptor(File destination, String version, boolean isPro) {
        this.destination = destination;
        this.version = version;
        this.isPro = isPro;
    }

    public File getFile() {
        return this.destination;
    }

    public String getName() {
        if (this.isPro) {
            return "iReport ".concat(this.version).concat(" ").concat(PRO_STRING);
        }
        return "iReport ".concat(this.version);
    }

    public Properties getConfiguration() {
        if (this.configurationProperties == null) {
            this.configurationProperties = this.loadConfiguration();
        }
        return this.configurationProperties;
    }

    protected Properties loadConfiguration() {
        Properties prop = new Properties();
        String path = this.destination.getAbsolutePath().concat(ImportUtility.FILE_SEPARATOR).concat("ireport.properties");
        File newFile = new File(path);
        try {
            if (newFile.exists()) {
                FileInputStream is = new FileInputStream(newFile);
                prop.load(is);
                is.close();
                Properties result = new Properties();
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String key = entry.getKey().toString();
                    if (key.startsWith("ireport.jrproperty.") && key.length() > 19) {
                        result.put(key.substring(19), entry.getValue());
                        continue;
                    }
                    result.put(key, entry.getValue());
                }
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected Properties loadServerConfiguration() {
        Properties prop = new Properties();
        String path = this.destination.getAbsolutePath().concat(ImportUtility.FILE_SEPARATOR).concat("ireport").concat(ImportUtility.FILE_SEPARATOR).concat("jasperserver.properties");
        File newFile = new File(path);
        try {
            if (newFile.exists()) {
                FileInputStream is = new FileInputStream(newFile);
                prop.load(is);
                is.close();
                return prop;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Properties getServerConnection() {
        if (this.serverProperties == null) {
            this.serverProperties = this.loadServerConfiguration();
        }
        return this.serverProperties;
    }
}

