/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.adapter;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.adapter.ImportUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class JSSDescriptor
extends IReportDescriptor {
    private File installationStorages;

    public JSSDescriptor(File destination) {
        super(destination, "", false);
    }

    @Override
    public String getName() {
        this.version = this.getConfiguration().getProperty("jssbranding_product_version");
        if (this.version != null) {
            return "JasperSoft Studio  ".concat(this.version);
        }
        return "JasperSoft Studio";
    }

    private void loadStorage() {
        this.installationStorages = new File(this.destination.getAbsolutePath().concat(ImportUtility.FILE_SEPARATOR).concat(".plugins").concat(ImportUtility.FILE_SEPARATOR).concat("com.jaspersoft.studio"));
    }

    @Override
    protected Properties loadConfiguration() {
        Properties prop = new Properties();
        String path = this.destination.getAbsolutePath().concat(ImportUtility.FILE_SEPARATOR).concat(".plugins").concat(ImportUtility.FILE_SEPARATOR).concat("org.eclipse.core.runtime").concat(ImportUtility.FILE_SEPARATOR).concat(".settings").concat(ImportUtility.FILE_SEPARATOR).concat("com.jaspersoft.studio.prefs");
        File newFile = new File(path);
        try {
            if (newFile.exists()) {
                FileInputStream is = new FileInputStream(newFile);
                prop.load(is);
                is.close();
                return prop;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public File[] getStorageResources(String storageName) {
        File storage;
        if (this.installationStorages == null) {
            this.loadStorage();
        }
        if (this.installationStorages.exists() && this.installationStorages.isDirectory() && (storage = new File(this.installationStorages, storageName)).exists()) {
            return storage.listFiles();
        }
        return new File[0];
    }

    @Override
    protected Properties loadServerConfiguration() {
        return super.getConfiguration();
    }
}

