/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.customadapters;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.adapter.IDataAdapterCreator;
import com.jaspersoft.studio.data.customadapters.ConfigurableDataAdapterDescriptor;
import com.jaspersoft.studio.data.customadapters.ui.AdapterWidgetsDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.swt.ResourceManager;

public class ConfigurableDataAdapterFactory
implements DataAdapterFactory {
    private AdapterWidgetsDescriptor descriptor;

    public ConfigurableDataAdapterFactory(AdapterWidgetsDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public DataAdapterDescriptor createDataAdapter() {
        return new ConfigurableDataAdapterDescriptor(this.descriptor);
    }

    @Override
    public String getDataAdapterClassName() {
        return this.descriptor.getAdapterClass();
    }

    @Override
    public DataAdapterService createDataAdapterService(final JasperReportsContext jasperReportsContext, DataAdapter dataAdapter) {
        ParameterContributorContext paramContribContext = new ParameterContributorContext(jasperReportsContext, null, null);
        DataAdapterService service = DataAdapterServiceUtil.getInstance((ParameterContributorContext)paramContribContext).getService(dataAdapter);
        if (service != null) {
            return service;
        }
        return new DataAdapterService(){

            public void dispose() {
            }

            public void contributeParameters(Map<String, Object> parameters) throws JRException {
            }

            public void test() throws JRException {
                ConfigurableDataAdapterFactory.this.testExistence((JasperReportsConfiguration)jasperReportsContext);
            }
        };
    }

    @Override
    public String getLabel() {
        return this.descriptor.getLabel();
    }

    @Override
    public String getDescription() {
        return this.descriptor.getDescription();
    }

    private ImageData resizeImage(ImageData sourceImageData, int x, int y, int width, int height) {
        if (sourceImageData.width == width && sourceImageData.height == height) {
            return sourceImageData;
        }
        Image sourceImage = new Image((Device)Display.getCurrent(), sourceImageData);
        Image scaledImage = new Image((Device)Display.getCurrent(), width, height);
        GC gc = new GC((Drawable)scaledImage);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(sourceImage, 0, 0, sourceImage.getBounds().width, sourceImage.getBounds().height, 0, 0, width, height);
        gc.dispose();
        ImageData croppedImageData = scaledImage.getImageData();
        scaledImage.dispose();
        sourceImage.dispose();
        return croppedImageData;
    }

    @Override
    public Image getIcon(int size) {
        if (this.descriptor.getIconPath() != null) {
            ImageData data;
            ImageDescriptor desc;
            String key = "DA_IMAGE_" + this.descriptor.getIconPath() + size;
            Image image = ResourceManager.getImage((String)key);
            if (image == null && (desc = ResourceManager.getImageDescriptor((String)this.descriptor.getIconPath())) != null && (data = desc.getImageData()) != null) {
                data = this.resizeImage(data, 0, 0, size, size);
                image = new Image((Device)UIUtils.getDisplay(), data);
                ResourceManager.addImage((String)key, (Image)image);
            }
            return image;
        }
        return null;
    }

    public void testExistence(JasperReportsConfiguration jConfig) throws JRException {
        try {
            Class<?> clazz = jConfig.getClassLoader().loadClass(this.descriptor.getAdapterClass());
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            DataAdapter cfr_ignored_0 = (DataAdapter)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new JRException("Unable to instantiate the data adapter", (Throwable)ex);
        }
    }

    @Override
    public IDataAdapterCreator iReportConverter() {
        return null;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }
}

