/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer.tree;

import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.wb.swt.ResourceManager;

public class NodeBoldStyledLabelProvider<T extends ANode>
extends StyledCellLabelProvider {
    private List<T> selectedNodes = new ArrayList<T>();

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = new StyledString();
        if (element instanceof ANode) {
            ANode node = (ANode)element;
            if (this.selectedNodes.contains(node)) {
                final Font boldFont = ResourceManager.getBoldFont((Font)this.getViewer().getControl().getFont());
                text.append(((ANode)element).getDisplayText(), new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = boldFont;
                    }
                });
            } else {
                text.append(((ANode)element).getDisplayText());
            }
        } else if (element instanceof CustomStyleStatus) {
            text.append(((CustomStyleStatus)element).getMessage());
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        cell.setImage(this.getImage(element));
        super.update(cell);
    }

    private Image getImage(Object element) {
        if (element instanceof ANode) {
            return ResourceManager.getImage((ImageDescriptor)((ANode)element).getImagePath());
        }
        if (element instanceof CustomStyleStatus) {
            return ((CustomStyleStatus)element).getImage();
        }
        return null;
    }

    public void setSelectedNodes(List<T> selectedNodes) {
        this.selectedNodes.clear();
        this.selectedNodes.addAll(selectedNodes);
    }

    public static interface CustomStyleStatus {
        public String getMessage();

        public Image getImage();
    }
}

