/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.storage;

import com.jaspersoft.studio.ConfigurationManager;
import com.jaspersoft.studio.IConversionFilenameProvider;
import java.io.File;
import java.util.HashMap;
import org.w3c.dom.Node;

public class TemplateNameConverter
implements IConversionFilenameProvider {
    private static HashMap<String, TemplateNameConverter> convertersMap = new HashMap();
    private String templateType;
    private int actualIndex = 0;

    private TemplateNameConverter(String templateType) {
        File[] otherStyles;
        this.templateType = templateType;
        File[] fileArray = otherStyles = ConfigurationManager.getStorageContent(templateType);
        int n = otherStyles.length;
        int n2 = 0;
        while (n2 < n) {
            File otherStyle = fileArray[n2];
            String name = otherStyle.getName();
            int counterStartPosition = name.lastIndexOf("_");
            int counterEndPosition = name.lastIndexOf(".");
            if (counterStartPosition != -1 && counterEndPosition != -1) {
                String counterText = name.substring(counterStartPosition + 1, counterEndPosition);
                try {
                    int counter = Integer.valueOf(counterText) + 1;
                    if (counter > this.actualIndex) {
                        this.actualIndex = counter;
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    @Override
    public String getFileName(Node configurationElementNode) {
        String name = String.valueOf(this.templateType) + "_" + this.actualIndex + ".xml";
        ++this.actualIndex;
        return name;
    }

    public static TemplateNameConverter getConverter(String templateType) {
        TemplateNameConverter converter = convertersMap.get(templateType);
        if (converter == null) {
            converter = new TemplateNameConverter(templateType);
            convertersMap.put(templateType, converter);
        }
        return converter;
    }
}

