/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.ui;

import com.jaspersoft.studio.data.ADataAdapterComposite;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.messages.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DefaultDataAdapterEditorComposite
extends ADataAdapterComposite {
    private WizardPage wizardPage = null;
    private DataAdapterDescriptor dataAdapterDesc = null;
    private TableViewer tableViewer;
    private Table table;
    private TableViewerColumn propertyViewerColumn;
    private TableViewerColumn valueViewerColumn;
    private Button addButton;
    private Button deleteButton;
    private List<String[]> rows;

    public DefaultDataAdapterEditorComposite(Composite parent, int style, WizardPage wizardPage, JasperReportsContext jrContext) {
        super(parent, style, jrContext);
        this.setLayout((Layout)new GridLayout(2, false));
        this.rows = new ArrayList<String[]>();
        this.wizardPage = wizardPage;
        this.tableViewer = new TableViewer((Composite)this, 67586);
        this.tableViewer.setContentProvider((IContentProvider)new DefaultContentProvider());
        this.tableViewer.setInput(this.rows);
        this.table = this.tableViewer.getTable();
        GridData gd_table = new GridData(4, 4, true, true, 1, 1);
        gd_table.minimumWidth = 200;
        this.table.setLayoutData((Object)gd_table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.propertyViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.propertyViewerColumn.getColumn().setMoveable(true);
        this.propertyViewerColumn.getColumn().setWidth(100);
        this.propertyViewerColumn.getColumn().setText(Messages.DefaultDataAdapterEditorComposite_properyLabel);
        this.propertyViewerColumn.setLabelProvider((CellLabelProvider)new ColumnPropertyValueLabelProvider(0));
        this.propertyViewerColumn.setEditingSupport((EditingSupport)new PropertyValueEditingSupport(this.tableViewer, 0));
        this.valueViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        this.valueViewerColumn.getColumn().setMoveable(true);
        this.valueViewerColumn.getColumn().setWidth(100);
        this.valueViewerColumn.getColumn().setText(Messages.DefaultDataAdapterEditorComposite_valueLabel);
        this.valueViewerColumn.setLabelProvider((CellLabelProvider)new ColumnPropertyValueLabelProvider(1));
        this.valueViewerColumn.setEditingSupport((EditingSupport)new PropertyValueEditingSupport(this.tableViewer, 1));
        Composite buttonComposite = new Composite((Composite)this, 0);
        GridLayout gl_buttonComposite = new GridLayout(1, false);
        gl_buttonComposite.marginWidth = 0;
        gl_buttonComposite.marginHeight = 0;
        buttonComposite.setLayout((Layout)gl_buttonComposite);
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.addButton = new Button(buttonComposite, 0);
        GridData gd_addButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_addButton.widthHint = 100;
        this.addButton.setLayoutData((Object)gd_addButton);
        this.addButton.setText(Messages.DefaultDataAdapterEditorComposite_addButton);
        this.deleteButton = new Button(buttonComposite, 0);
        GridData gd_deleteButton = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_deleteButton.widthHint = 100;
        this.deleteButton.setLayoutData((Object)gd_deleteButton);
        this.deleteButton.setText(Messages.DefaultDataAdapterEditorComposite_deleteButton);
        this.deleteButton.setEnabled(false);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDataAdapterEditorComposite.this.rows.add(DefaultDataAdapterEditorComposite.this.createDataModelEntry());
                if (DefaultDataAdapterEditorComposite.this.rows.size() == 1) {
                    DefaultDataAdapterEditorComposite.this.deleteButton.setEnabled(true);
                }
                DefaultDataAdapterEditorComposite.this.tableViewer.refresh();
                DefaultDataAdapterEditorComposite.this.setTableSelection(-1);
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultDataAdapterEditorComposite.this.removeEntries();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    DefaultDataAdapterEditorComposite.this.removeEntries();
                }
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DefaultDataAdapterEditorComposite.this.rows.size() <= 0) {
                    DefaultDataAdapterEditorComposite.this.deleteButton.setEnabled(false);
                } else {
                    DefaultDataAdapterEditorComposite.this.deleteButton.setEnabled(true);
                }
            }
        });
    }

    @Override
    protected void bindWidgets(DataAdapter dataAdapter) {
        HashMap map = new HashMap();
        if (map.size() > 0) {
            Object[] keys = new String[map.size()];
            Iterator it = map.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                keys[i] = (String)it.next();
                ++i;
            }
            Arrays.sort(keys);
            Object[] objectArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                this.rows.add(new String[]{key, (String)map.get(key)});
                ++n2;
            }
            this.tableViewer.refresh();
            this.setTableSelection(-1);
            this.deleteButton.setEnabled(true);
        }
    }

    @Override
    public DataAdapterDescriptor getDataAdapter() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] row : this.rows) {
            map.put(row[0], row[1]);
        }
        return this.dataAdapterDesc;
    }

    private String[] createDataModelEntry() {
        int i = 0;
        String property = "PROPERTY_" + i;
        while (!this.isPropertyValid(property)) {
            property = "PROPERTY_" + ++i;
        }
        return new String[]{property, ""};
    }

    private void removeEntries() {
        int[] indices = this.table.getSelectionIndices();
        if (indices.length > 0) {
            Arrays.sort(indices);
            int removedItems = 0;
            int[] nArray = indices;
            int n = indices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.rows.remove(i - removedItems);
                ++removedItems;
                ++n2;
            }
            this.tableViewer.refresh();
            this.setTableSelection(indices[0]);
        }
    }

    private void setTableSelection(int index) {
        if (this.rows != null && this.rows.size() > 0) {
            if (index == 0) {
                this.table.setSelection(index);
            } else if (index > 0 && index < this.rows.size() - 1) {
                this.table.setSelection(index - 1);
            } else {
                this.table.setSelection(this.rows.size() - 1);
            }
        }
    }

    private boolean isPropertyValid(String property) {
        if (property == null || "".equals(property)) {
            return false;
        }
        for (String[] row : this.rows) {
            if (!row[0].equals(property)) continue;
            return false;
        }
        return true;
    }

    private class ColumnPropertyValueLabelProvider
    extends ColumnLabelProvider {
        private int columnIndex;

        private ColumnPropertyValueLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            String[] row = (String[])element;
            return row[this.columnIndex].toString();
        }
    }

    private class DefaultContentProvider
    implements IStructuredContentProvider {
        private DefaultContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyValueEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private int columnIndex;

        public PropertyValueEditingSupport(TableViewer viewer, int columnIndex) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.columnIndex = columnIndex;
        }

        protected CellEditor getCellEditor(Object element) {
            final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.viewer.getTable());
            textCellEditor.addListener(new ICellEditorListener(){

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage != null) {
                        String str = textCellEditor.getValue().toString().trim();
                        if (DefaultDataAdapterEditorComposite.this.isPropertyValid(str)) {
                            ((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage.setMessage(null);
                        } else if (str.length() > 0) {
                            ((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage.setMessage(MessageFormat.format(Messages.DefaultDataAdapterEditorComposite_alredyExistingMessage, str), 3);
                        } else {
                            ((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage.setMessage(Messages.DefaultDataAdapterEditorComposite_specifyNameMessage, 3);
                        }
                    }
                }

                public void cancelEditor() {
                }

                public void applyEditorValue() {
                    if (((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage != null) {
                        ((PropertyValueEditingSupport)PropertyValueEditingSupport.this).DefaultDataAdapterEditorComposite.this.wizardPage.setMessage(null);
                    }
                }
            });
            return textCellEditor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((String[])element)[this.columnIndex].toString();
        }

        protected void setValue(Object element, Object value) {
            String str = String.valueOf(value);
            if (this.columnIndex == 0) {
                if (DefaultDataAdapterEditorComposite.this.isPropertyValid(str)) {
                    ((String[])element)[this.columnIndex] = str;
                    this.viewer.refresh();
                }
            } else if (this.columnIndex == 1) {
                ((String[])element)[this.columnIndex] = str;
                this.viewer.refresh();
            }
        }
    }
}

