/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.widget;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.widget.IDataAdapterRunnable;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.TooltipCCombo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.eclipse.viewer.IReportViewerListener;
import net.sf.jasperreports.eclipse.viewer.ReportViewerEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;

public class DatasourceComboItem
extends ContributionItem
implements PropertyChangeListener,
IReportViewerListener,
Listener {
    private TooltipCCombo combo;
    private ToolItem toolitem;
    private IPartListener partListener;
    private IDataAdapterRunnable editor;
    private ADataAdapterStorage[] dastorages;
    private DataAdapterDescriptor selectedDA;

    public DatasourceComboItem(IDataAdapterRunnable editor, ADataAdapterStorage[] dastorages) {
        super("datasourceadaptercomboitem");
        this.editor = editor;
        this.setDataAdapterStorages(dastorages);
    }

    public void setDataAdapterStorages(ADataAdapterStorage[] dastorages) {
        ADataAdapterStorage das;
        int n;
        int n2;
        ADataAdapterStorage[] aDataAdapterStorageArray;
        if (this.dastorages != null) {
            aDataAdapterStorageArray = dastorages;
            n2 = dastorages.length;
            n = 0;
            while (n < n2) {
                das = aDataAdapterStorageArray[n];
                das.removePropertyChangeListener(this);
                ++n;
            }
        }
        this.dastorages = dastorages;
        if (dastorages != null) {
            aDataAdapterStorageArray = dastorages;
            n2 = dastorages.length;
            n = 0;
            while (n < n2) {
                das = aDataAdapterStorageArray[n];
                das.addPropertyChangeListener(this);
                ++n;
            }
        }
        this.refresh(true);
    }

    public void updateDataAdapters() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        this.combo.removeListener(13, this);
        this.combo.removeListener(14, this);
        DataAdapterDescriptor selectedAdapter = this.getSelected();
        this.combo.removeAll();
        this.combo.add("-- " + Messages.DatasourceComboItem_select_a_datasource + " --");
        if (this.dastorages != null) {
            int i = 0;
            while (i < this.dastorages.length) {
                ADataAdapterStorage s = this.dastorages[i];
                for (DataAdapterDescriptor d : s.getDataAdapterDescriptors()) {
                    this.combo.add(d.getName(), s.getUrl(d));
                }
                if (!s.getDataAdapterDescriptors().isEmpty() && i < this.dastorages.length - 1 && !this.dastorages[i + 1].getDataAdapterDescriptors().isEmpty()) {
                    this.combo.add("----------------------");
                }
                ++i;
            }
        }
        this.setSelected(selectedAdapter);
        this.combo.pack();
        Point size = this.combo.getSize();
        Rectangle bounds = this.combo.getBounds();
        bounds.width = Math.max(300, size.x);
        this.combo.setBounds(bounds);
        this.combo.setSize(size.x, bounds.height);
        this.toolitem.setWidth(size.x + 20);
        this.combo.addListener(13, this);
        this.combo.addListener(14, this);
    }

    public void setSelected(DataAdapterDescriptor selectedAdapter) {
        if (selectedAdapter != null) {
            int j = 1;
            int newSelectionIndex = 0;
            if (this.dastorages != null) {
                int i = 0;
                while (i < this.dastorages.length) {
                    ADataAdapterStorage s = this.dastorages[i];
                    for (DataAdapterDescriptor d : s.getDataAdapterDescriptors()) {
                        if (selectedAdapter == d) {
                            newSelectionIndex = j;
                            break;
                        }
                        ++j;
                    }
                    if (newSelectionIndex > 0) break;
                    if (!s.getDataAdapterDescriptors().isEmpty() && i < this.dastorages.length - 1) {
                        ++j;
                    }
                    ++i;
                }
            }
            this.combo.select(newSelectionIndex);
        }
        if (this.combo.getSelectionIndex() < 0 && this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
        this.handleWidgetDefaultSelected(null);
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.editor.isNotRunning();
    }

    public void refresh(boolean repopulateCombo) {
        block6: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (!this.isEnabled()) {
                    this.combo.setEnabled(false);
                } else {
                    if (repopulateCombo) {
                        this.updateDataAdapters();
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block6;
                throw exception;
            }
        }
    }

    private void selectCombo(int i) {
        this.combo.select(i);
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    protected Control createControl(Composite parent) {
        this.combo = new TooltipCCombo(parent, 2060);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DatasourceComboItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DatasourceComboItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DatasourceComboItem.this.refresh(false);
            }
        });
        this.refresh(true);
        this.toolitem.setWidth(this.computeWidth((Control)this.combo));
        return this.combo;
    }

    public void dispose() {
        if (this.partListener == null) {
            return;
        }
        ADataAdapterStorage[] aDataAdapterStorageArray = this.dastorages;
        int n = this.dastorages.length;
        int n2 = 0;
        while (n2 < n) {
            ADataAdapterStorage das = aDataAdapterStorageArray[n2];
            das.removePropertyChangeListener(this);
            ++n2;
        }
        this.combo = null;
        this.partListener = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.combo.getSelectionIndex() > 0) {
            final DataAdapterDescriptor da = this.getSelected();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DatasourceComboItem.this.selectedDA = da;
                    DatasourceComboItem.this.editor.runReport(da, false);
                }
            });
        }
        this.refresh(false);
    }

    public DataAdapterDescriptor getSelected() {
        if (!this.combo.isDisposed()) {
            int index = this.combo.getSelectionIndex();
            if (index <= 0) {
                return null;
            }
            if (this.dastorages != null) {
                int j = 1;
                int i = 0;
                while (i < this.dastorages.length) {
                    ADataAdapterStorage s = this.dastorages[i];
                    for (DataAdapterDescriptor d : s.getDataAdapterDescriptors()) {
                        if (j == index) {
                            this.selectedDA = d;
                            this.selectCombo(index);
                            return d;
                        }
                        ++j;
                    }
                    if (!s.getDataAdapterDescriptors().isEmpty() && i < this.dastorages.length - 1) {
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this.selectedDA;
    }

    private void handleWidgetSelected(SelectionEvent event) {
        this.handleWidgetDefaultSelected(event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(true);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.refresh(false);
                break;
            }
        }
    }

    public void viewerStateChanged(ReportViewerEvent evt) {
        this.refresh(false);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }
}

