/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.wizard.AbstractDataAdapterWizard;
import com.jaspersoft.studio.data.wizard.pages.DataAdapterEditorPage;
import com.jaspersoft.studio.messages.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class DataAdapterWizardDialog
extends WizardDialog {
    List<SelectionListener> listeners = new ArrayList<SelectionListener>();
    Button testButton = null;

    public DataAdapterWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    public void addTestListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeTestListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void fireTestPressed(SelectionEvent e) {
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(e);
        }
    }

    public void updateButtons() {
        super.updateButtons();
        boolean canFinish = this.getWizard().canFinish();
        this.testButton.setEnabled(canFinish);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns = 1;
        this.testButton = new Button(parent, 0);
        this.testButton.setFont(parent.getFont());
        this.testButton.setText(Messages.DataAdapterWizardDialog_0);
        this.setButtonLayoutData(this.testButton);
        this.testButton.setEnabled(false);
        this.testButton.setVisible(false);
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DataAdapterWizardDialog.this.fireTestPressed(event);
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    private boolean isTestVisible() {
        boolean isTestVisible = false;
        if (this.getWizard() instanceof AbstractDataAdapterWizard && this.getCurrentPage() instanceof DataAdapterEditorPage) {
            DataAdapterDescriptor dataAdapterDesc = ((DataAdapterEditorPage)this.getCurrentPage()).getDataAdapter();
            isTestVisible = dataAdapterDesc != null ? dataAdapterDesc.doSupportTest() : false;
        }
        return isTestVisible;
    }

    public void setTestButtonEnabled(boolean b) {
        boolean testVisible = this.isTestVisible();
        this.testButton.setEnabled(b && testVisible && this.getWizard().canFinish());
        this.testButton.setVisible(testVisible);
    }
}

