/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.wizard.AbstractDataAdapterWizard;
import com.jaspersoft.studio.data.wizard.pages.DataAdapterEditorPage;
import com.jaspersoft.studio.data.wizard.pages.DataAdaptersListPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextData;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class NewFileDataAdapterWizard
extends AbstractDataAdapterWizard
implements INewWizard,
SelectionListener {
    public static final String WIZARD_ID = "com.jaspersoft.studio.data.wizard.NewFileDataAdapterWizard";
    private ISelection selection;
    private WizardNewFileCreationPage step1;
    private IFile file;

    public NewFileDataAdapterWizard() {
        this.setWindowTitle(Messages.DataAdapterWizard_windowtitle);
        this.storage = DataAdapterManager.getPreferencesStorage();
        this.setConfig(JasperReportsConfiguration.getDefaultJRConfig(), true);
        JDTUtils.deactivateLinkedResourcesSupport();
    }

    public NewFileDataAdapterWizard(DataAdapterDescriptor dataAdapter) {
        this();
        this.dataAdapter = dataAdapter;
    }

    @Override
    public void addPages() {
        this.step1 = new WizardNewAdapterPage("newFilePage1", (IStructuredSelection)this.selection, ContextHelpIDs.WIZARD_NEW_DATAAPDATER);
        this.step1.setTitle(Messages.NewFileDataAdapterWizard_1);
        this.step1.setDescription(Messages.NewFileDataAdapterWizard_2);
        this.step1.setFileExtension("jrdax");
        this.setupNewFileName();
        this.addPage((IWizardPage)this.step1);
        if (this.dataAdapter == null) {
            this.dataAdapterListPage = new DataAdaptersListPage();
            this.addPage((IWizardPage)this.dataAdapterListPage);
        }
        this.dataAdapterEditorPage = new DataAdapterEditorPage();
        if (this.dataAdapter != null) {
            this.dataAdapterEditorPage.setEditMode(true);
        }
        this.addPage((IWizardPage)this.dataAdapterEditorPage);
    }

    public void setupNewFileName() {
        String filename = "DataAdapter.jrdax";
        if (this.selection != null) {
            TreeSelection s;
            if (this.selection instanceof TreeSelection && (s = (TreeSelection)this.selection).getFirstElement() instanceof IFile) {
                IFile file = (IFile)s.getFirstElement();
                String f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                int i = 1;
                while (file.getProject().getFile(f).exists()) {
                    filename = "DataAdapter" + i + ".jrdax";
                    f = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toOSString()) + "/" + filename;
                    ++i;
                }
            }
            this.step1.setFileName(filename);
        }
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.step1) {
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(this.step1.getContainerFullPath());
            IFile file = r.getProject().getFile(this.step1.getContainerFullPath() + Messages.ReportNewWizard_1 + this.step1.getFileName());
            this.getConfig().init(file);
        }
        if (page == this.dataAdapterListPage) {
            DataAdapterFactory factory = this.dataAdapterListPage.getSelectedFactory();
            MessageFormat fm = new MessageFormat(Messages.DataAdapterWizard_newdataadaptername);
            try {
                DataAdapterDescriptor newDataAdapter = factory.createDataAdapter();
                newDataAdapter.getDataAdapter(this.getConfig()).setName(fm.format(new Object[]{1}));
                if (this.selectedFactory != factory) {
                    this.dataAdapterEditorPage.setJrContext((JasperReportsContext)this.getConfig());
                    this.dataAdapterEditorPage.setDataAdapter(newDataAdapter);
                    this.selectedFactory = factory;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return super.getNextPage(page);
    }

    @Override
    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.dataAdapter != null) {
            DataAdapterDescriptor editedDataAdapter = DataAdapterManager.cloneDataAdapter(this.dataAdapter, (JasperReportsContext)this.getConfig());
            this.dataAdapterEditorPage.setDataAdapter(editedDataAdapter);
        }
    }

    @Override
    public boolean performFinish() {
        JDTUtils.restoreLinkedResourcesSupport();
        DataAdapterDescriptor editedDataAdapter = this.dataAdapterEditorPage.getDataAdapter();
        this.dataAdapterEditorPage.performFinishInvoked();
        if (this.dataAdapter == null) {
            this.dataAdapter = editedDataAdapter;
        } else {
            String oldName = this.dataAdapter.getName();
            this.dataAdapter.setDataAdapter(editedDataAdapter.getDataAdapter());
            this.dataAdapter.getDataAdapter().setName(oldName);
        }
        final String containerName = this.step1.getContainerFullPath().toPortableString();
        final String fileName = this.step1.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewFileDataAdapterWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    public boolean performCancel() {
        JDTUtils.restoreLinkedResourcesSupport();
        return super.performCancel();
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            String message = "Container \"" + containerName + "\" does not exist.";
            Status status = new Status(4, "com.jaspersoft.studio", 0, message, null);
            throw new CoreException((IStatus)status);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                NewFileDataAdapterWizard.this.file = NewFileDataAdapterWizard.this.step1.createNewFile();
            }
        });
        ByteArrayInputStream in = null;
        try {
            String xml = DataAdapterManager.toDataAdapterFile(this.dataAdapter, (JasperReportsContext)this.getConfig());
            in = new ByteArrayInputStream(xml.getBytes());
            if (this.file.exists()) {
                this.file.setContents((InputStream)in, true, true, monitor);
            } else {
                this.file.create((InputStream)in, true, monitor);
            }
            DataAdapterManager.getDataAdapter(this.file, this.file.getProject(), this.getConfig());
        }
        catch (Throwable throwable) {
            FileUtils.closeStream(in);
            throw throwable;
        }
        FileUtils.closeStream((Closeable)in);
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.openEditor(this.file);
        monitor.worked(1);
    }

    protected void openEditor(final IFile file) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.setDefaultEditor((IFile)file, (String)"com.jaspersoft.studio.data.DataAdapterEditorPart");
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"com.jaspersoft.studio.data.DataAdapterEditorPart");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection instanceof StructuredSelection) {
            IProject p;
            IProject[] prjs;
            if (selection.getFirstElement() instanceof IProject || selection.getFirstElement() instanceof IFile || selection.getFirstElement() instanceof IFolder || selection.getFirstElement() instanceof IPackageFragment) {
                this.selection = selection;
                return;
            }
            for (Object obj : selection.toList()) {
                IEditorInput ein;
                if (!(obj instanceof EditPart) || !((ein = SelectionHelper.getActiveJRXMLEditor().getEditorInput()) instanceof FileEditorInput)) continue;
                this.selection = new TreeSelection(new TreePath(new Object[]{((FileEditorInput)ein).getFile()}));
                return;
            }
            NullProgressMonitor progressMonitor = new NullProgressMonitor();
            IProject[] iProjectArray = prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = prjs.length;
            int n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (ProjectUtil.isOpen((IProject)p) && p.getNature("org.eclipse.jdt.core.javanature") != null) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile("DataAdapter.jrdax")}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            iProjectArray = prjs;
            n = prjs.length;
            n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                try {
                    if (p.isAccessible()) {
                        p.open((IProgressMonitor)progressMonitor);
                        this.selection = new TreeSelection(new TreePath(new Object[]{p.getFile("DataAdapter.jrdax")}));
                        return;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.selection = selection;
    }

    private class WizardNewAdapterPage
    extends WizardNewFileCreationPage
    implements ContextData {
        protected String contextName;

        public WizardNewAdapterPage(String pageName, IStructuredSelection selection, String contextName) {
            super(pageName, selection);
            this.contextName = contextName;
        }

        protected void setControl(Control newControl) {
            super.setControl(newControl);
            newControl.addListener(28, new Listener(){

                public void handleEvent(Event event) {
                    WizardNewAdapterPage.this.performHelp();
                }
            });
            this.setHelpData();
        }

        @Override
        public void setHelpData() {
            if (this.contextName != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.contextName);
            }
        }

        public void performHelp() {
            if (this.contextName != null) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp(this.contextName);
            }
        }

        public boolean canFlipToNextPage() {
            if (JDTUtils.isVirtualResource((IPath)this.getContainerFullPath())) {
                this.setErrorMessage(Messages.NewFileDataAdapterWizard_VirtualFolderError);
                return false;
            }
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getContainerFullPath());
            String fileName = this.getFileName();
            IFile file = r.getProject().getFile(fileName);
            if (file.exists()) {
                return false;
            }
            if (!fileName.endsWith(".jrdax")) {
                fileName = String.valueOf(fileName) + ".jrdax";
            }
            return !(file = r.getProject().getFile(fileName)).exists();
        }

        public boolean isPageComplete() {
            return !JDTUtils.isVirtualResource((IPath)this.getContainerFullPath()) && super.isPageComplete();
        }

        public void setVisible(boolean visible) {
            JDTUtils.deactivateLinkedResourcesSupport((boolean)visible);
            super.setVisible(visible);
        }
    }
}

