/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.wizard.ImportDataAdapterWizard;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.events.ChangeEvent;
import com.jaspersoft.studio.swt.events.ChangeListener;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.MoveT2TButtons;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PropertiesPage
extends JSSWizardPage {
    protected List<String> propertiesSelected = new ArrayList<String>();
    protected Table rightTable;
    protected TableViewer leftTView;
    private TableViewer rightTView;
    private MoveT2TButtons mt2t = null;
    protected Properties prop = null;

    protected PropertiesPage() {
        super("addcategories");
        this.setTitle(Messages.PropertiesPage_title);
        this.setDescription(Messages.PropertiesPage_description);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)panel);
        Composite composite = new Composite(panel, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftPanel = new Composite(composite, 0);
        GridLayout leftLayout = new GridLayout(2, false);
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 5;
        leftLayout.marginHeight = 0;
        leftLayout.marginWidth = 0;
        leftPanel.setLayout((Layout)leftLayout);
        leftPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        Table leftTable = new Table(leftPanel, 68098);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        leftTable.setLayoutData((Object)gd);
        leftTable.setHeaderVisible(true);
        TableColumn[] col = new TableColumn[]{new TableColumn(leftTable, 0)};
        col[0].setText(Messages.PropertiesPage_availableColName);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        leftTable.setLayout((Layout)tlayout);
        this.leftTView = new TableViewer(leftTable);
        this.leftTView.setContentProvider((IContentProvider)new ListContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.leftTView, (int)2);
        this.setLabelProvider(this.leftTView);
        Composite bGroup = new Composite(composite, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.rightTable = new Table(composite, 68098);
        gd = new GridData(1808);
        gd.minimumWidth = 300;
        this.rightTable.setLayoutData((Object)gd);
        this.rightTable.setHeaderVisible(true);
        this.createColumns();
        this.rightTView = new TableViewer(this.rightTable);
        this.rightTView.setContentProvider((IContentProvider)new ListContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.rightTView, (int)2);
        this.setLabelProvider(this.rightTView);
        this.mt2t = new MoveT2TButtons();
        this.mt2t.createButtons(bGroup, (ColumnViewer)this.leftTView, this.rightTView);
        this.mt2t.addChangeListener(new ChangeListener(){

            @Override
            public void changed(ChangeEvent event) {
                PropertiesPage.this.storeSettings();
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.leftTView.setInput(this.getInFields());
            this.rightTView.setInput(new ArrayList());
            this.rightTView.refresh();
        }
    }

    protected List<String> getInFields() {
        ArrayList<String> readKeys = new ArrayList<String>();
        IReportDescriptor selectedConfig = ((ImportDataAdapterWizard)this.getWizard()).getSelectedConfiguration();
        this.prop = selectedConfig.getConfiguration();
        Set<String> storedKeys = this.prop.stringPropertyNames();
        for (String key : storedKeys) {
            if (!key.startsWith("net.sf.jasperreports")) continue;
            readKeys.add(key);
        }
        return readKeys;
    }

    public void storeSettings() {
        this.propertiesSelected.clear();
        TableItem[] tableItemArray = this.rightTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.propertiesSelected.add(item.getData().toString());
            ++n2;
        }
    }

    public List<String> getProperties() {
        return this.propertiesSelected;
    }

    protected void createColumns() {
        TableColumn[] col = new TableColumn[]{new TableColumn(this.rightTable, 0)};
        col[0].setText(Messages.PropertiesPage_importColName);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(cell.getElement().toString());
            }

            public String getToolTipText(Object element) {
                return element.toString().concat("=").concat(PropertiesPage.this.prop.getProperty(element.toString()));
            }

            public Point getToolTipShift(Object object) {
                return new Point(5, 5);
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 100;
            }

            public int getToolTipTimeDisplayed(Object object) {
                return 5000;
            }
        });
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_SELECT_PROPERTIES;
    }
}

