/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard;

import com.jaspersoft.studio.data.adapter.IReportDescriptor;
import com.jaspersoft.studio.data.adapter.JSSDescriptor;
import com.jaspersoft.studio.data.wizard.ListInstallationPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.swt.widgets.DirectoryDialog;

public class SelectWorkspacePage
extends ListInstallationPage {
    private static FilenameFilter metaDataFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.equals(".metadata");
        }
    };

    public SelectWorkspacePage() {
        this.setTitle(Messages.SelectWorkspacePage_title);
        this.setDescription(Messages.SelectWorkspacePage_description);
        this.setPageComplete(false);
    }

    @Override
    protected List<IReportDescriptor> getFoundedConfiguration() {
        return new ArrayList<IReportDescriptor>();
    }

    @Override
    protected String getPath() {
        DirectoryDialog fd = new DirectoryDialog(UIUtils.getShell(), 4096);
        fd.setText(Messages.SelectWorkspacePage_openTitle);
        fd.setFilterPath(".metadata");
        return fd.open();
    }

    @Override
    protected IReportDescriptor getDescriptor(String path) {
        File newFile = new File(path);
        if (newFile.exists()) {
            if (newFile.getName().equals(".metadata")) {
                return new JSSDescriptor(newFile);
            }
            File[] children = newFile.listFiles(metaDataFilter);
            if (children.length > 0) {
                return new JSSDescriptor(children[0]);
            }
        }
        return null;
    }

    @Override
    public IReportDescriptor getSelection() {
        return (IReportDescriptor)this.customRadio.getData();
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_WORKSPACE;
    }
}

