/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard.imp;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ImportDAPage
extends JSSHelpWizardPage {
    private TreeViewer viewer;
    private List<DataAdapterDescriptor> selection;
    private boolean overwrite = false;

    protected ImportDAPage() {
        super("importda");
        this.setTitle(Messages.ImportDAPage_1);
        this.setDescription(Messages.ImportDAPage_2);
    }

    @Override
    protected String getContextName() {
        return ContextHelpIDs.WIZARD_IMPORT_SELECT_ADAPTERS;
    }

    public List<DataAdapterDescriptor> getDataAdapterDescriptors() {
        return this.selection;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void createControl(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        this.setControl((Control)cmp);
        cmp.setLayout((Layout)new GridLayout());
        this.viewer = new TreeViewer(cmp, 2818);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
            this.setPageComplete(!s.isEmpty());
            this.selection = new ArrayList<DataAdapterDescriptor>();
            for (Object obj : s.toList()) {
                if (obj instanceof DataAdapterDescriptor) {
                    this.selection.add((DataAdapterDescriptor)obj);
                    continue;
                }
                if (!(obj instanceof ADataAdapterStorage)) continue;
                this.selection.addAll(((ADataAdapterStorage)obj).getDataAdapterDescriptors());
            }
        });
        final Button bOverwrite = new Button(cmp, 32);
        bOverwrite.setText(Messages.ImportDAPage_3);
        bOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDAPage.this.overwrite = bOverwrite.getSelection();
            }
        });
        this.fillData();
        this.setPageComplete(false);
    }

    private void fillData() {
        List<ADataAdapterStorage> das = DataAdapterManager.getProjectStorages();
        this.viewer.setInput(das);
        this.viewer.expandAll();
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ADataAdapterStorage) {
                return ((ADataAdapterStorage)parentElement).getDataAdapterDescriptors().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ADataAdapterStorage;
        }
    }

    class ViewLabelProvider
    extends StyledCellLabelProvider {
        ViewLabelProvider() {
        }

        public String getToolTipText(Object element) {
            if (element instanceof ADataAdapterStorage) {
                return ((ADataAdapterStorage)element).getStorageName();
            }
            if (element instanceof DataAdapterDescriptor) {
                return ((DataAdapterDescriptor)element).getDataAdapter().getName();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            StyledString text = new StyledString();
            if (element instanceof ADataAdapterStorage) {
                text.append(((ADataAdapterStorage)element).getStorageName());
                cell.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/prj_obj.gif"));
            } else if (element instanceof DataAdapterDescriptor) {
                DataAdapterDescriptor dad = (DataAdapterDescriptor)element;
                for (ADataAdapterStorage das : DataAdapterManager.getProjectStorages()) {
                    if (das.findDataAdapter(dad.getName()) == null) continue;
                    text.append(das.getLabel(dad));
                    break;
                }
                cell.setImage(((DataAdapterDescriptor)element).getIcon(16));
            }
            cell.setText(text.toString());
            cell.setStyleRanges(text.getStyleRanges());
            super.update(cell);
        }
    }
}

