/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.wizard.pages;

import com.jaspersoft.studio.data.DataAdapterFactory;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.customadapters.ConfigurableDataAdapterFactory;
import com.jaspersoft.studio.data.wizard.pages.LLabelProvider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class DataAdaptersListPage
extends WizardPage {
    private List<DataAdapterFactory> dataAdapterFactories = null;
    private TableViewer tviewer;
    private Table wtable;

    public DataAdaptersListPage() {
        super("dataAdapterslistpage");
        this.setTitle(Messages.DataAdaptersListPage_1);
        this.setDescription(Messages.DataAdaptersListPage_2);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        this.wtable = new Table(container, 68100);
        GridData gd = new GridData(1808);
        gd.widthHint = 100;
        gd.heightHint = 250;
        this.wtable.setLayoutData((Object)gd);
        this.wtable.setHeaderVisible(false);
        TableColumn[] col = new TableColumn[]{new TableColumn(this.wtable, 0)};
        col[0].setText(Messages.DataAdaptersListPage_3);
        col[0].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, false));
        this.wtable.setLayout((Layout)tlayout);
        this.tviewer = new TableViewer(this.wtable);
        this.tviewer.setContentProvider((IContentProvider)new DataAdapterContentProvider());
        this.tviewer.setLabelProvider((IBaseLabelProvider)new LLabelProvider());
        this.tviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (DataAdaptersListPage.this.canFlipToNextPage()) {
                    DataAdaptersListPage.this.getContainer().showPage(DataAdaptersListPage.this.getNextPage());
                }
            }
        });
        this.wtable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int ind = DataAdaptersListPage.this.wtable.getSelectionIndex();
                if (ind >= 0 && ind < DataAdaptersListPage.this.dataAdapterFactories.size()) {
                    DataAdaptersListPage.this.setMessage(DataAdaptersListPage.this.dataAdapterFactories.get(ind).getDescription());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateFactoriesList();
        this.tviewer.setInput(this.dataAdapterFactories);
        if (this.dataAdapterFactories.size() > 0) {
            this.wtable.setSelection(0);
            this.setPageComplete(this.wtable.getSelectionCount() > 0);
            this.setMessage(this.dataAdapterFactories.get(0).getDescription());
        }
    }

    public boolean canFlipToNextPage() {
        this.tviewer.refresh();
        return this.wtable.getSelectionCount() == 1;
    }

    protected void factorySelected(SelectionEvent e) {
        this.setPageComplete(this.wtable.getSelectionCount() > 0);
    }

    private void updateFactoriesList() {
        ArrayList<DataAdapterFactory> list = new ArrayList<DataAdapterFactory>();
        for (DataAdapterFactory daf : DataAdapterManager.getDataAdapterFactories()) {
            if (daf.isDeprecated()) continue;
            list.add(daf);
        }
        this.dataAdapterFactories = list;
    }

    public DataAdapterFactory getSelectedFactory() {
        if (this.dataAdapterFactories == null) {
            return null;
        }
        if (this.wtable.getSelectionIndex() < 0) {
            return null;
        }
        return this.dataAdapterFactories.get(this.wtable.getSelectionIndex());
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.jaspersoft.studio.doc.dataAdapters_wizard_list");
    }

    private class DataAdapterContentProvider
    extends ListContentProvider {
        private DataAdapterContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ArrayList elements = null;
            if (inputElement != null && inputElement instanceof List) {
                elements = new ArrayList((List)inputElement);
            } else if (inputElement != null && inputElement instanceof Collection) {
                elements = new ArrayList((Collection)inputElement);
            }
            if (elements != null) {
                ArrayList result = new ArrayList();
                for (Object element : elements) {
                    if (element instanceof ConfigurableDataAdapterFactory) {
                        ConfigurableDataAdapterFactory configurableFactory = (ConfigurableDataAdapterFactory)element;
                        JSSWizard wizard = (JSSWizard)DataAdaptersListPage.this.getWizard();
                        JasperReportsConfiguration jConfig = wizard.getConfig();
                        if (jConfig == null) {
                            jConfig = JasperReportsConfiguration.getDefaultInstance();
                        }
                        try {
                            configurableFactory.testExistence(jConfig);
                            result.add(element);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    result.add(element);
                }
                return result.toArray();
            }
            return new Object[0];
        }
    }
}

