/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.debug;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.model.dataset.MDataset;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.field.MFields;
import com.jaspersoft.studio.model.parameter.MParameterSystem;
import com.jaspersoft.studio.model.parameter.MParameters;
import com.jaspersoft.studio.model.variable.MVariableSystem;
import com.jaspersoft.studio.model.variable.MVariables;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxLabelProvider;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.CollectionElementAddedEvent;
import net.sf.jasperreports.engine.design.events.CollectionElementRemovedEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.Page;

public class TracePage
extends Page {
    private JrxmlEditor editor;
    private TreeViewer treeViewer;
    private Tree tree;
    private Combo cmb;
    private List<TreeColumn> cols = new ArrayList<TreeColumn>();
    private JRDesignDataset dataset;
    private PropertyChangeListener jrdsObjListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            JasperReportsConfiguration jrContext = TracePage.this.editor.getJrContext();
            JRDataset ds = this.getDataset(jrContext.getJasperDesign(), arg0.getSource());
            if (ds == null) {
                return;
            }
            String key = "com.jaspersoft.studio.trace.field.";
            if (arg0.getSource() instanceof JRField) {
                key = "com.jaspersoft.studio.trace.field.";
            } else if (arg0.getSource() instanceof JRVariable) {
                key = "com.jaspersoft.studio.trace.variable.";
            } else if (arg0.getSource() instanceof JRParameter) {
                key = "com.jaspersoft.studio.trace.parameter.";
            }
            String pname = arg0.getPropertyName();
            if (pname.equals("name")) {
                TracePage.this.renameDSObject(jrContext, key, (String)arg0.getOldValue(), (String)arg0.getNewValue(), ds);
            }
        }

        private JRDataset getDataset(JasperDesign jd, Object obj) {
            if (this.getDataset(jd.getMainDataset(), obj)) {
                return jd.getMainDataset();
            }
            for (JRDataset ds : jd.getDatasetsList()) {
                if (!this.getDataset(ds, obj)) continue;
                return ds;
            }
            return null;
        }

        private boolean getDataset(JRDataset ds, Object obj) {
            JRField f;
            int n;
            int n2;
            JRField[] jRFieldArray;
            if (obj instanceof JRField) {
                jRFieldArray = ds.getFields();
                n2 = jRFieldArray.length;
                n = 0;
                while (n < n2) {
                    f = jRFieldArray[n];
                    if (f == obj) {
                        return true;
                    }
                    ++n;
                }
            }
            if (obj instanceof JRVariable) {
                jRFieldArray = ds.getVariables();
                n2 = jRFieldArray.length;
                n = 0;
                while (n < n2) {
                    f = jRFieldArray[n];
                    if (f == obj) {
                        return true;
                    }
                    ++n;
                }
            }
            if (obj instanceof JRParameter) {
                jRFieldArray = ds.getParameters();
                n2 = jRFieldArray.length;
                n = 0;
                while (n < n2) {
                    f = jRFieldArray[n];
                    if (f == obj) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
    };
    private PropertyChangeListener jrdsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            JasperReportsConfiguration jrContext = TracePage.this.editor.getJrContext();
            JRDataset ds = (JRDataset)arg0.getSource();
            String pname = arg0.getPropertyName();
            if (pname.equals("name")) {
                TracePage.this.renameDS(jrContext, (String)arg0.getOldValue(), (String)arg0.getNewValue(), ds);
            } else if (pname.equals("fields")) {
                if (arg0 instanceof CollectionElementAddedEvent) {
                    JRDesignField f = (JRDesignField)((CollectionElementAddedEvent)arg0).getNewValue();
                    f.getEventSupport().addPropertyChangeListener(TracePage.this.jrdsObjListener);
                } else if (arg0 instanceof CollectionElementRemovedEvent) {
                    JRField f = (JRField)((CollectionElementRemovedEvent)arg0).getRemovedValue();
                    TracePage.this.cleanup(jrContext, "com.jaspersoft.studio.trace.field.", f.getName(), ds);
                }
            } else if (pname.equals("variables")) {
                if (arg0 instanceof CollectionElementAddedEvent) {
                    JRDesignVariable f = (JRDesignVariable)((CollectionElementAddedEvent)arg0).getNewValue();
                    f.getEventSupport().addPropertyChangeListener(TracePage.this.jrdsObjListener);
                } else if (arg0 instanceof CollectionElementRemovedEvent) {
                    JRVariable f = (JRVariable)((CollectionElementRemovedEvent)arg0).getRemovedValue();
                    TracePage.this.cleanup(jrContext, "com.jaspersoft.studio.trace.variable.", f.getName(), ds);
                }
            } else if (pname.equals("parameters")) {
                if (arg0 instanceof CollectionElementAddedEvent) {
                    JRDesignParameter f = (JRDesignParameter)((CollectionElementAddedEvent)arg0).getNewValue();
                    f.getEventSupport().addPropertyChangeListener(TracePage.this.jrdsObjListener);
                } else if (arg0 instanceof CollectionElementRemovedEvent) {
                    JRParameter f = (JRParameter)((CollectionElementRemovedEvent)arg0).getRemovedValue();
                    TracePage.this.cleanup(jrContext, "com.jaspersoft.studio.trace.parameter.", f.getName(), ds);
                }
            }
        }
    };
    private PropertyChangeListener dsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals("datasets")) {
                if (arg0 instanceof CollectionElementRemovedEvent) {
                    JRField f;
                    JasperReportsConfiguration jrContext = TracePage.this.editor.getJrContext();
                    JRDataset ds = (JRDataset)((CollectionElementRemovedEvent)arg0).getRemovedValue();
                    String key = "com.jaspersoft.studio.trace.field.";
                    JRField[] jRFieldArray = ds.getFields();
                    int n = jRFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        f = jRFieldArray[n2];
                        TracePage.this.cleanup(jrContext, key, f.getName(), ds);
                        ++n2;
                    }
                    key = "com.jaspersoft.studio.trace.variable.";
                    jRFieldArray = ds.getVariables();
                    n = jRFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        f = jRFieldArray[n2];
                        TracePage.this.cleanup(jrContext, key, f.getName(), ds);
                        ++n2;
                    }
                    key = "com.jaspersoft.studio.trace.parameter.";
                    jRFieldArray = ds.getParameters();
                    n = jRFieldArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        f = jRFieldArray[n2];
                        TracePage.this.cleanup(jrContext, key, f.getName(), ds);
                        ++n2;
                    }
                }
                TracePage.this.setupDatasets();
            }
        }
    };
    private Composite cmp;

    public TracePage(JrxmlEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.cmp = new Composite(parent, 0);
        this.cmp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(this.cmp, 0);
        lbl.setText("Data Sets");
        this.cmb = new Combo(this.cmp, 2056);
        this.cmb.setLayoutData((Object)new GridData(768));
        this.cmb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracePage.this.setupDatasets();
                TracePage.this.treeViewer.refresh(true);
                TracePage.this.treeViewer.expandAll();
            }
        });
        this.tree = new Tree(this.cmp, 2816);
        this.tree.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(this.tree);
        TreeColumn column1 = new TreeColumn(this.tree, 16384);
        this.tree.setLinesVisible(true);
        column1.setAlignment(16384);
        column1.setText("Report Objects");
        column1.setWidth(160);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !property.isEmpty() && (element instanceof MField || element instanceof MVariableSystem || element instanceof MParameterSystem);
            }

            public Object getValue(Object element, String property) {
                JasperReportsConfiguration jrConfig = TracePage.this.editor.getJrContext();
                String type = null;
                String name = null;
                if (element instanceof MField) {
                    type = "field.";
                    name = ((MField)element).getValue().getName();
                } else if (element instanceof MVariableSystem) {
                    type = "variable.";
                    name = ((MVariableSystem)element).getValue().getName();
                } else if (element instanceof MParameterSystem) {
                    type = "parameter.";
                    name = ((MParameterSystem)element).getValue().getName();
                } else {
                    return null;
                }
                return jrConfig.getPropertyBoolean("com.jaspersoft.studio.trace." + type + TracePage.this.dataset.getName() + "." + property + name, false);
            }

            public void modify(Object element, String property, Object value) {
                Object e = element;
                if (element instanceof TreeItem) {
                    e = ((TreeItem)element).getData();
                }
                JasperReportsConfiguration jrConfig = TracePage.this.editor.getJrContext();
                String type = null;
                String name = null;
                if (e instanceof MField) {
                    type = "field.";
                    name = ((MField)e).getValue().getName();
                } else if (e instanceof MVariableSystem) {
                    type = "variable.";
                    name = ((MVariableSystem)e).getValue().getName();
                } else if (e instanceof MParameterSystem) {
                    type = "parameter.";
                    name = ((MParameterSystem)e).getValue().getName();
                } else {
                    return;
                }
                if (value instanceof Boolean) {
                    Boolean b = (Boolean)value;
                    jrConfig.setProperty("com.jaspersoft.studio.trace." + type + TracePage.this.dataset.getName() + "." + property + name, b.toString());
                    TracePage.this.treeViewer.update(element, new String[]{property});
                    TracePage.this.treeViewer.refresh();
                }
            }
        });
        this.setupData();
    }

    private void createColumns() {
        for (TreeColumn c : this.cols) {
            c.dispose();
        }
        this.createColumn("Before Report Init", "beforeReportInit.");
        this.createColumn("After Report Init", "afterReportInit.");
        this.createColumn("Before Page Init", "beforePageInit.");
        this.createColumn("After Page Init", "afterPageInit.");
        this.createColumn("Before Column Init", "beforeColumnInit.");
        this.createColumn("After Column Init", "afterColumnInit.");
        for (JRGroup gr : this.dataset.getGroupsList()) {
            String n = gr.getName();
            this.createColumn("Before Group [" + n + "] Init", "beforeGroupInit." + n + ".");
            this.createColumn("After Group [" + n + "] Init", "afterGroupInit." + n + ".");
        }
        this.createColumn("Before Detail Eval", "beforeDetailEval.");
        this.createColumn("After Detail Eval", "afterDetailEval.");
        CellEditor[] editors = new CellEditor[this.tree.getColumnCount()];
        String[] props = new String[this.tree.getColumnCount()];
        int i = 0;
        while (i < this.tree.getColumns().length) {
            editors[i] = i == 0 ? new TextCellEditor(this.cmp) : new CheckboxCellEditor(this.cmp);
            props[i] = Misc.nvl((Object)this.tree.getColumn(i).getData("COLNAME"), (String)"");
            ++i;
        }
        this.treeViewer.setCellEditors(editors);
        this.treeViewer.setColumnProperties(props);
    }

    private void createColumn(String label, String property) {
        TreeColumn c = new TreeColumn(this.tree, 131072);
        c.setAlignment(16384);
        c.setText(label);
        c.setWidth(100);
        c.setData("COLNAME", (Object)property);
        this.cols.add(c);
    }

    private void setupData() {
        UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TracePage.this.setupDatasets();
                if (TracePage.this.editor != null) {
                    TracePage.this.treeViewer.setInput((Object)TracePage.this.editor.getModel());
                    TracePage.this.treeViewer.expandAll();
                }
            }
        });
    }

    private void setupDatasets() {
        String sel = null;
        if (this.cmb.getSelectionIndex() >= 0) {
            sel = this.cmb.getItem(this.cmb.getSelectionIndex());
        }
        ArrayList<String> datasets = new ArrayList<String>();
        datasets.add("Main Data Set");
        if (this.editor != null && this.editor.getJrContext() != null && this.editor.getJrContext().getJasperDesign() != null) {
            JasperDesign jd = this.editor.getJrContext().getJasperDesign();
            for (JRDataset ds : jd.getDatasetsList()) {
                JRField f;
                datasets.add(ds.getName());
                JRDesignDataset jrds = (JRDesignDataset)ds;
                jrds.getEventSupport().removePropertyChangeListener(this.jrdsListener);
                jrds.getEventSupport().addPropertyChangeListener(this.jrdsListener);
                JRField[] jRFieldArray = ds.getFields();
                int n = jRFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    f = jRFieldArray[n2];
                    ((JRDesignField)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                    ((JRDesignField)f).getEventSupport().addPropertyChangeListener(this.jrdsObjListener);
                    ++n2;
                }
                jRFieldArray = ds.getVariables();
                n = jRFieldArray.length;
                n2 = 0;
                while (n2 < n) {
                    f = jRFieldArray[n2];
                    ((JRDesignVariable)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                    ((JRDesignVariable)f).getEventSupport().addPropertyChangeListener(this.jrdsObjListener);
                    ++n2;
                }
                jRFieldArray = ds.getParameters();
                n = jRFieldArray.length;
                n2 = 0;
                while (n2 < n) {
                    f = jRFieldArray[n2];
                    ((JRDesignParameter)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                    ((JRDesignParameter)f).getEventSupport().addPropertyChangeListener(this.jrdsObjListener);
                    ++n2;
                }
            }
            this.cmb.setItems(datasets.toArray(new String[datasets.size()]));
            jd.getEventSupport().removePropertyChangeListener(this.dsListener);
            jd.getEventSupport().addPropertyChangeListener(this.dsListener);
            int indx = 0;
            if (sel != null) {
                int i = 0;
                while (i < this.cmb.getItemCount()) {
                    if (this.cmb.getItem(i).equals(sel)) {
                        indx = i;
                        break;
                    }
                    ++i;
                }
            }
            this.cmb.select(indx);
            this.setDataset();
            this.createColumns();
        }
    }

    private void setDataset() {
        int indx = this.cmb.getSelectionIndex();
        JasperDesign jd = this.editor.getJrContext().getJasperDesign();
        if (indx > 0) {
            String dsname = this.cmb.getItem(indx);
            for (JRDataset ds : jd.getDatasetsList()) {
                if (!ds.getName().equals(dsname)) continue;
                this.dataset = (JRDesignDataset)ds;
                break;
            }
        } else {
            this.dataset = jd.getMainDesignDataset();
        }
    }

    private void cleanup(JasperReportsConfiguration jrContext, String key, String fn, JRDataset ds) {
        String n = ds.getName();
        jrContext.removeProperty(String.valueOf(key) + n + "." + "beforeReportInit." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "afterReportInit." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "beforePageInit." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "afterPageInit." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "beforeColumnInit." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "afterColumnInit." + fn);
        JRGroup[] jRGroupArray = ds.getGroups();
        int n2 = jRGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JRGroup gr = jRGroupArray[n3];
            jrContext.removeProperty(String.valueOf(key) + n + "." + "beforeGroupInit." + gr.getName() + "." + fn);
            jrContext.removeProperty(String.valueOf(key) + n + "." + "afterGroupInit." + gr.getName() + "." + fn);
            ++n3;
        }
        jrContext.removeProperty(String.valueOf(key) + n + "." + "beforeDetailEval." + fn);
        jrContext.removeProperty(String.valueOf(key) + n + "." + "afterDetailEval." + fn);
    }

    private void renameDS(JasperReportsConfiguration jrContext, String fn, String newFn, JRDataset ds) {
        this.renameDSByType(jrContext, "beforeReportInit.", fn, newFn, ds);
        this.renameDSByType(jrContext, "afterReportInit.", fn, newFn, ds);
        this.renameDSByType(jrContext, "beforePageInit.", fn, newFn, ds);
        this.renameDSByType(jrContext, "afterPageInit.", fn, newFn, ds);
        this.renameDSByType(jrContext, "beforeColumnInit.", fn, newFn, ds);
        this.renameDSByType(jrContext, "afterColumnInit.", fn, newFn, ds);
        JRGroup[] jRGroupArray = ds.getGroups();
        int n = jRGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRGroup gr = jRGroupArray[n2];
            this.renameDSByType(jrContext, "beforeGroupInit." + gr.getName(), fn, newFn, ds);
            this.renameDSByType(jrContext, "afterGroupInit." + gr.getName(), fn, newFn, ds);
            ++n2;
        }
        this.renameDSByType(jrContext, "beforeDetailEval.", fn, newFn, ds);
        this.renameDSByType(jrContext, "afterDetailEval.", fn, newFn, ds);
    }

    private void renameDSByType(JasperReportsConfiguration jrContext, String type, String fn, String newFn, JRDataset ds) {
        String sufix;
        JRField f;
        String prefix = "com.jaspersoft.studio.trace.field.";
        JRField[] jRFieldArray = ds.getFields();
        int n = jRFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = jRFieldArray[n2];
            sufix = "." + type + f.getName();
            this.rename(jrContext, String.valueOf(prefix) + fn + sufix, String.valueOf(prefix) + newFn + sufix);
            ++n2;
        }
        prefix = "com.jaspersoft.studio.trace.variable.";
        jRFieldArray = ds.getVariables();
        n = jRFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = jRFieldArray[n2];
            sufix = "." + type + f.getName();
            this.rename(jrContext, String.valueOf(prefix) + fn + sufix, String.valueOf(prefix) + newFn + sufix);
            ++n2;
        }
        prefix = "com.jaspersoft.studio.trace.parameter.";
        jRFieldArray = ds.getParameters();
        n = jRFieldArray.length;
        n2 = 0;
        while (n2 < n) {
            f = jRFieldArray[n2];
            sufix = "." + type + f.getName();
            this.rename(jrContext, String.valueOf(prefix) + fn + sufix, String.valueOf(prefix) + newFn + sufix);
            ++n2;
        }
    }

    private void renameDSObject(JasperReportsConfiguration jrContext, String key, String fn, String newFn, JRDataset ds) {
        String n = ds.getName();
        String skey = String.valueOf(key) + n + "." + "beforeReportInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "beforeReportInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "afterReportInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "beforePageInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "afterPageInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "beforeColumnInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "afterColumnInit.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        JRGroup[] jRGroupArray = ds.getGroups();
        int n2 = jRGroupArray.length;
        int n3 = 0;
        while (n3 < n2) {
            JRGroup gr = jRGroupArray[n3];
            skey = String.valueOf(key) + n + "." + "beforeGroupInit." + gr.getName() + ".";
            this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
            skey = String.valueOf(key) + n + "." + "afterGroupInit." + gr.getName() + ".";
            this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
            ++n3;
        }
        skey = String.valueOf(key) + n + "." + "beforeDetailEval.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
        skey = String.valueOf(key) + n + "." + "afterDetailEval.";
        this.rename(jrContext, String.valueOf(skey) + fn, String.valueOf(skey) + newFn);
    }

    private void rename(JasperReportsConfiguration jrContext, String oldkey, String newKey) {
        String old = jrContext.getProperty(oldkey);
        if (old != null) {
            jrContext.setProperty(newKey, old);
            jrContext.removeProperty(oldkey);
        }
    }

    public void dispose() {
        JasperDesign jd = this.editor.getJrContext().getJasperDesign();
        for (JRDataset ds : jd.getDatasetsList()) {
            JRField f;
            JRDesignDataset jrds = (JRDesignDataset)ds;
            jrds.getEventSupport().removePropertyChangeListener(this.jrdsListener);
            JRField[] jRFieldArray = ds.getFields();
            int n = jRFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                f = jRFieldArray[n2];
                ((JRDesignField)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                ++n2;
            }
            jRFieldArray = ds.getVariables();
            n = jRFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                f = jRFieldArray[n2];
                ((JRDesignVariable)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                ++n2;
            }
            jRFieldArray = ds.getParameters();
            n = jRFieldArray.length;
            n2 = 0;
            while (n2 < n) {
                f = jRFieldArray[n2];
                ((JRDesignParameter)f).getEventSupport().removePropertyChangeListener(this.jrdsObjListener);
                ++n2;
            }
        }
        jd.getEventSupport().removePropertyChangeListener(this.dsListener);
        super.dispose();
    }

    public Control getControl() {
        return this.cmp;
    }

    public void setFocus() {
        this.cmp.setFocus();
    }

    class TableLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        private CheckBoxLabelProvider cblp = new CheckBoxLabelProvider(NullEnum.NOTNULL);

        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                INode n = (INode)element;
                return JaspersoftStudioPlugin.getInstance().getImage(n.getImagePath());
            }
            if (element instanceof MField || element instanceof MVariableSystem || element instanceof MParameterSystem) {
                JasperReportsConfiguration jrConfig = TracePage.this.editor.getJrContext();
                String type = null;
                String name = null;
                if (element instanceof MField) {
                    type = "field.";
                    name = ((MField)element).getValue().getName();
                } else if (element instanceof MVariableSystem) {
                    type = "variable.";
                    name = ((MVariableSystem)element).getValue().getName();
                } else if (element instanceof MParameterSystem) {
                    type = "parameter.";
                    name = ((MParameterSystem)element).getValue().getName();
                } else {
                    return null;
                }
                String level = (String)TracePage.this.tree.getColumn(columnIndex).getData("COLNAME");
                Boolean b = jrConfig.getPropertyBoolean("com.jaspersoft.studio.trace." + type + TracePage.this.dataset.getName() + "." + level + name, false);
                return this.cblp.getCellEditorImage(b);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    INode n = (INode)element;
                    if (n instanceof MReport) {
                        return "Main Dataset";
                    }
                    return n.getDisplayText();
                }
                case 1: {
                    return this.getCellValue(element, "beforeReportInit.");
                }
                case 2: {
                    return this.getCellValue(element, "afterReportInit.");
                }
                case 3: {
                    return this.getCellValue(element, "beforePageInit.");
                }
                case 4: {
                    return this.getCellValue(element, "afterPageInit.");
                }
                case 5: {
                    return this.getCellValue(element, "beforeColumnInit.");
                }
                case 6: {
                    return this.getCellValue(element, "afterColumnInit.");
                }
                case 7: {
                    return this.getCellValue(element, "beforeGroupInit.");
                }
                case 8: {
                    return this.getCellValue(element, "afterGroupInit.");
                }
                case 9: {
                    return this.getCellValue(element, "beforeDetailEval.");
                }
                case 10: {
                    return this.getCellValue(element, "afterDetailEval.");
                }
            }
            return "haha";
        }

        public String getToolTipText(Object element) {
            return super.getToolTipText(element);
        }

        private String getCellValue(Object element, String level) {
            if (element instanceof INode) {
                JasperReportsConfiguration jrConfig = TracePage.this.editor.getJrContext();
                String type = null;
                String name = null;
                if (element instanceof MField) {
                    type = "field.";
                    name = ((MField)element).getValue().getName();
                } else if (element instanceof MVariableSystem) {
                    type = "variable.";
                    name = ((MVariableSystem)element).getValue().getName();
                } else if (element instanceof MParameterSystem) {
                    type = "parameter.";
                    name = ((MParameterSystem)element).getValue().getName();
                } else {
                    return "";
                }
                Boolean b = jrConfig.getPropertyBoolean("com.jaspersoft.studio.trace." + type + TracePage.this.dataset.getName() + "." + level + name, false);
                return b.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TreeContentProvider
    implements ITreeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof INode) {
                ArrayList<INode> nodes = new ArrayList<INode>();
                INode n = (INode)parentElement;
                MReport mrep = null;
                if (n instanceof MRoot) {
                    for (INode child : n.getChildren()) {
                        if (!(child instanceof MReport)) continue;
                        mrep = (MReport)child;
                        break;
                    }
                } else if (n instanceof MReport) {
                    if (((MReport)n).getValue().getMainDataset().equals(TracePage.this.dataset)) {
                        for (INode child : n.getChildren()) {
                            if (child instanceof MParameters) {
                                nodes.add(child);
                                continue;
                            }
                            if (child instanceof MVariables) {
                                nodes.add(child);
                                continue;
                            }
                            if (!(child instanceof MFields)) continue;
                            nodes.add(child);
                        }
                    }
                } else if (n instanceof MDataset) {
                    if (((MDataset)n).getValue().equals(TracePage.this.dataset)) {
                        for (INode child : n.getChildren()) {
                            if (child instanceof MParameters) {
                                nodes.add(child);
                                continue;
                            }
                            if (child instanceof MVariables) {
                                nodes.add(child);
                                continue;
                            }
                            if (!(child instanceof MFields)) continue;
                            nodes.add(child);
                        }
                    }
                } else if (n instanceof MParameters) {
                    nodes.addAll(n.getChildren());
                } else if (n instanceof MVariables) {
                    nodes.addAll(n.getChildren());
                } else if (n instanceof MFields) {
                    nodes.addAll(n.getChildren());
                }
                if (mrep != null) {
                    if (mrep.getValue().getMainDataset().equals(TracePage.this.dataset)) {
                        nodes.add(mrep);
                    }
                    for (INode child : mrep.getChildren()) {
                        if (!(child instanceof MDataset) || !((MDataset)child).getValue().equals(TracePage.this.dataset)) continue;
                        nodes.add(child);
                    }
                }
                return nodes.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof INode) {
                return ((INode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof INode) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }

        public Object[] getElements(Object elements) {
            return this.getChildren(elements);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

