/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.dnd;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.MDataAdapter;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DataAdapterDragSourceListener
implements TransferDragSourceListener {
    private static final String ENCODING = "UTF-8";
    private static final String DATA_ADAPTER_FILE_PREFIX = "dataAdapter";
    private static final String DATA_ADAPTER_FILE_EXT = ".jrdax";
    private String[] dataAdapterFilesLocations = new String[0];

    public void dragStart(DragSourceEvent event) {
        event.doit = !this.getDragSelection(event).isEmpty();
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.getTransfer().isSupportedType(event.dataType)) {
            List<MDataAdapter> dataAdaptersSelected = this.getDragSelection(event);
            ArrayList<String> locations = new ArrayList<String>(dataAdaptersSelected.size());
            for (MDataAdapter da : dataAdaptersSelected) {
                locations.add(this.createTemDataAdapterFile(da));
            }
            event.data = this.dataAdapterFilesLocations = locations.toArray(new String[locations.size()]);
        } else {
            this.dataAdapterFilesLocations = new String[0];
            event.data = null;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        String[] stringArray = this.dataAdapterFilesLocations;
        int n = this.dataAdapterFilesLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String daFileLocation = stringArray[n2];
            FileUtils.deleteQuietly((File)new File(daFileLocation));
            ++n2;
        }
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    private List<MDataAdapter> getDragSelection(DragSourceEvent event) {
        if (event.getSource() instanceof DragSource) {
            ArrayList<MDataAdapter> dataAdapters = new ArrayList<MDataAdapter>();
            Control control = ((DragSource)event.getSource()).getControl();
            if (control instanceof Tree && ((Tree)control).getSelection().length > 0) {
                TreeItem[] treeItemArray = ((Tree)control).getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem tItem = treeItemArray[n2];
                    Object data = tItem.getData();
                    if (data instanceof MDataAdapter) {
                        dataAdapters.add((MDataAdapter)data);
                    }
                    ++n2;
                }
                return dataAdapters;
            }
        }
        return new ArrayList<MDataAdapter>(0);
    }

    private String createTemDataAdapterFile(MDataAdapter dataAdapter) {
        try {
            JasperReportsConfiguration jrConfig;
            File tempDirectory = FileUtils.getTempDirectory();
            String tempDataAdapterFilePath = String.valueOf(tempDirectory.getAbsolutePath()) + "/" + StringUtils.deleteWhitespace((String)dataAdapter.getDisplayText()) + DATA_ADAPTER_FILE_EXT;
            File tempDataAdapterFile = new File(tempDataAdapterFilePath);
            if (tempDataAdapterFile.exists()) {
                tempDataAdapterFile = File.createTempFile(DATA_ADAPTER_FILE_PREFIX, DATA_ADAPTER_FILE_EXT);
            }
            if ((jrConfig = dataAdapter.getJasperConfiguration()) == null) {
                jrConfig = JasperReportsConfiguration.getDefaultInstance();
            }
            String xml = DataAdapterManager.toDataAdapterFile(dataAdapter.getValue(), (JasperReportsContext)jrConfig);
            FileUtils.writeByteArrayToFile((File)tempDataAdapterFile, (byte[])xml.getBytes(ENCODING));
            return tempDataAdapterFile.getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            JaspersoftStudioPlugin.getInstance().logError(NLS.bind((String)Messages.DataAdapterDragSourceListener_EncondingErrorMsg, (Object)ENCODING), e);
        }
        catch (IOException e) {
            JaspersoftStudioPlugin.getInstance().logError(Messages.DataAdapterDragSourceListener_IOErrorMsg, e);
        }
        return null;
    }
}

