/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.ZoomActualAction;
import com.jaspersoft.studio.editor.action.ShowPropertyViewAction;
import com.jaspersoft.studio.editor.action.copy.CopyAction;
import com.jaspersoft.studio.editor.action.copy.CutAction;
import com.jaspersoft.studio.editor.action.copy.PasteAction;
import com.jaspersoft.studio.editor.gef.parts.MainDesignerRootEditPart;
import com.jaspersoft.studio.editor.java2d.J2DGraphicalEditor;
import com.jaspersoft.studio.editor.outline.JDReportOutlineView;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.report.EditorContributor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MRoot;
import com.jaspersoft.studio.properties.Activator;
import com.jaspersoft.studio.properties.view.ITabbedPropertySheetPageContributor;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AGraphicEditor
extends J2DGraphicalEditor
implements ITabbedPropertySheetPageContributor,
IGraphicalEditor,
CachedSelectionProvider {
    protected JasperReportsConfiguration jrContext;
    protected CommonSelectionCacheProvider cachedSelection = new CommonSelectionCacheProvider();
    private TabbedPropertySheetPage propertySheetPage;
    private INode model;
    private EditorContributor editorContributor;
    protected JDReportOutlineView outlinePage;

    public AGraphicEditor(JasperReportsConfiguration jrContext) {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.jrContext = jrContext;
    }

    public JasperReportsConfiguration getJrContext() {
        return this.jrContext;
    }

    @Override
    public FigureCanvas getEditor() {
        return (FigureCanvas)this.getGraphicalViewer().getControl();
    }

    @Override
    public SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    @Override
    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public String getContributorId() {
        return "com.jaspersoft.studio.editor.report.ReportContainer";
    }

    @Override
    public DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public void setModel(INode model) {
        this.model = model;
        if (this.outlinePage != null) {
            this.outlinePage.setContents(model);
        }
        if (model != null) {
            this.getGraphicalViewer().setContents((Object)model.getChildren().get(0));
        } else {
            this.getGraphicalViewer().setContents(null);
        }
    }

    @Override
    public INode getModel() {
        return this.model;
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySource.class) {
            return this.getPropertySheetPage();
        }
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        if (type == IContentOutlinePage.class) {
            return this.getOutlineView();
        }
        if (type == EditorContributor.class) {
            if (this.editorContributor == null) {
                this.editorContributor = new EditorContributor((EditDomain)this.getEditDomain());
            }
            return this.editorContributor;
        }
        return super.getAdapter(type);
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        this.propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        return this.propertySheetPage;
    }

    public void createPartControl(Composite parent) {
        this.createGraphicalViewer(parent);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.cachedSelection.selectionChanged(selection);
        this.updateActions(this.getSelectionActions());
    }

    @Override
    public CommonSelectionCacheProvider getSelectionCache() {
        return this.cachedSelection;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        MainDesignerRootEditPart rootEditPart = new MainDesignerRootEditPart();
        graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        graphicalViewer.setEditPartFactory(this.createEditParFactory());
        graphicalViewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(graphicalViewer));
        graphicalViewer.setContextMenu((MenuManager)this.createContextMenuProvider((EditPartViewer)graphicalViewer));
        ZoomManager zoomManager = (ZoomManager)graphicalViewer.getProperty(ZoomManager.class.toString());
        this.getActionRegistry().registerAction((IAction)new ZoomInAction(zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomOutAction(zoomManager));
        this.getActionRegistry().registerAction((IAction)new ZoomActualAction(zoomManager));
        graphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
        graphicalViewer.setProperty("JRCONTEXT", (Object)this.jrContext);
    }

    protected JDReportOutlineView getOutlineView() {
        if (this.outlinePage == null) {
            TreeViewer viewer = new TreeViewer();
            this.outlinePage = this.createOutline(viewer);
        }
        return this.outlinePage;
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        SelectionAction action = new CutAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        List selectionActions = this.getSelectionActions();
        selectionActions.add(action.getId());
        action = new CopyAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new PasteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
        action = new ShowPropertyViewAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        selectionActions.add(action.getId());
    }

    protected void initializeGraphicalViewer() {
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditDomain().getCommandStack().markSaveLocation();
    }

    public int getDefaultSelectedPageIndex() {
        boolean defaultValue;
        boolean advancedDefault;
        JasperReportsConfiguration jConfig;
        if (this.propertySheetPage != null && this.getModel() instanceof MRoot && this.getModel().getChildren().size() > 0 && (jConfig = ((ANode)this.getModel().getChildren().get(0)).getJasperConfiguration()) != null && (advancedDefault = jConfig.getPropertyBoolean("defaultAdvanced", defaultValue = Activator.getDefault().getPreferenceStore().getBoolean("defaultAdvanced")).booleanValue())) {
            return this.propertySheetPage.getCurrentTabs().size() - 1;
        }
        return 0;
    }

    protected abstract ContextMenuProvider createContextMenuProvider(EditPartViewer var1);

    protected abstract EditPartFactory createEditParFactory();

    protected abstract JDReportOutlineView createOutline(TreeViewer var1);
}

