/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.editor.DeltaVisitor;
import com.jaspersoft.studio.editor.IGraphicalEditor;
import com.jaspersoft.studio.editor.IMultiEditor;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.gef.parts.ReportPageEditPart;
import com.jaspersoft.studio.editor.outline.page.EmptyOutlinePage;
import com.jaspersoft.studio.editor.outline.page.MultiOutlineView;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.editor.xml.XMLEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class AMultiEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IMultiEditor {
    protected JasperReportsConfiguration jrContext;
    protected IContextActivation context;
    private ISelection tmpselection;
    private int activePage = 0;
    public static final String THEEDITOR = "thecurrenteditor";
    protected boolean isRefresh = false;
    boolean closing = false;
    protected INode model = null;
    private ModelPropertyChangeListener modelPropertyChangeListener = new ModelPropertyChangeListener();
    protected XMLEditor xmlEditor;
    private MultiOutlineView outlinePage;
    protected boolean xmlFresh = true;

    public AMultiEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 7);
    }

    protected void pageChange(int newPageIndex) {
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        if (this.activePage == 0) {
            this.tmpselection = this.outlinePage != null ? this.outlinePage.getSite().getSelectionProvider().getSelection() : this.getActiveEditor().getSite().getSelectionProvider().getSelection();
        }
        switch (newPageIndex) {
            case 0: {
                if (this.activePage == 1 && !this.xmlFresh) {
                    this.xml2model();
                }
                this.setModel(this.model);
                Display.getDefault().syncExec(() -> {
                    ISelectionProvider sp = null;
                    sp = this.outlinePage != null ? this.outlinePage.getSite().getSelectionProvider() : this.getActiveEditor().getSite().getSelectionProvider();
                    sp.setSelection(this.tmpselection);
                });
                if (this.context != null) break;
                this.context = service.activateContext("com.jaspersoft.studio.context");
                break;
            }
            case 1: {
                if (this.context != null) {
                    service.deactivateContext(this.context);
                }
                if (!this.isDirty()) break;
                this.model2xml();
            }
        }
        super.pageChange(newPageIndex);
        this.updateContentOutline(this.getActivePage());
        this.activePage = newPageIndex;
    }

    public void doSave(IProgressMonitor monitor) {
        this.isRefresh = true;
        String xml = null;
        if (this.activePage == 0) {
            xml = this.model2xml();
        } else if (this.activePage == 1) {
            this.xml2model();
        }
        this.doSaveParticipate(monitor);
        this.xmlEditor.doSave(monitor);
        if (xml != null) {
            try {
                IFile f = this.getCurrentFile();
                if (f != null) {
                    f.setContents((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), 3, monitor);
                }
            }
            catch (Throwable e) {
                UIUtils.showError((Throwable)e);
            }
        }
        Display.getDefault().asyncExec(() -> {
            this.isRefresh = false;
            this.firePropertyChange(257);
        });
        this.xmlFresh = true;
    }

    protected abstract void doSaveParticipate(IProgressMonitor var1);

    protected void xml2model() {
        IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
        ByteArrayInputStream in = new ByteArrayInputStream(doc.get().getBytes());
        this.xml2model(in);
    }

    protected abstract void xml2model(InputStream var1);

    protected String model2xml() {
        try {
            if (this.model != null) {
                String xml = this.doModel2xml();
                IDocumentProvider dp = this.xmlEditor.getDocumentProvider();
                IDocument doc = dp.getDocument((Object)this.xmlEditor.getEditorInput());
                if (xml != null && !Arrays.equals(doc.get().getBytes(), xml.getBytes())) {
                    doc.set(xml);
                }
                this.xmlFresh = true;
                return xml;
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        return null;
    }

    protected abstract String doModel2xml() throws Exception;

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: {
                Display.getDefault().asyncExec(() -> {
                    IWorkbenchPage[] pages = this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)this.xmlEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(this.xmlEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                });
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                try {
                    DeltaVisitor visitor = new DeltaVisitor((EditorPart)this);
                    event.getDelta().accept((IResourceDeltaVisitor)visitor);
                    if (this.jrContext == null || this.getEditorInput() == null) break;
                    this.jrContext.init(((IFileEditorInput)this.getEditorInput()).getFile());
                }
                catch (CoreException e) {
                    UIUtils.showError((Throwable)e);
                }
                break;
            }
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        IFile oldFile = ((FileEditorInput)this.getEditorInput()).getFile();
        saveAsDialog.setOriginalFile(oldFile);
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            IProgressMonitor monitor = this.getActiveEditor().getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor();
            try {
                file.create((InputStream)new ByteArrayInputStream("FILE".getBytes(StandardCharsets.UTF_8)), true, monitor);
                FileEditorInput modelFile = new FileEditorInput(file);
                this.setInputWithNotify((IEditorInput)modelFile);
                this.xmlEditor.setInput((IEditorInput)modelFile);
                this.setPartName(file.getName());
                this.jrContext.init(file);
                this.doSave(monitor);
            }
            catch (CoreException e) {
                UIUtils.showError((Throwable)e);
            }
        }
    }

    public JasperReportsConfiguration getJrContext(IFile file) throws CoreException, JavaModelException {
        if (this.jrContext == null) {
            this.jrContext = new JasperReportsConfiguration((JasperReportsContext)DefaultJasperReportsContext.getInstance(), file);
            this.jrContext.put(THEEDITOR, this);
        }
        return this.jrContext;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.setModel(null);
        if (this.jrContext != null) {
            this.jrContext.dispose();
        }
        super.dispose();
        if (this.context != null) {
            IContextService service = (IContextService)this.getSite().getService(IContextService.class);
            service.deactivateContext(this.context);
        }
    }

    protected IFile getCurrentFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (this.closing) {
            return;
        }
        monitor = new NullProgressMonitor();
        input = FileUtils.checkAndConvertEditorInput((IEditorInput)input, (IProgressMonitor)monitor);
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(input.getName());
        this.setInput(input);
        in = null;
        try {
            file = null;
            if (!(input instanceof IFileEditorInput)) ** GOTO lbl23
            file = ((IFileEditorInput)input).getFile();
            if (!file.getProject().isOpen()) {
                file.getProject().open((IProgressMonitor)monitor);
            }
            file.refreshLocal(0, (IProgressMonitor)monitor);
            if (!file.exists()) {
                this.closeEditor();
                return;
            }
            try {
                block20: {
                    in = file.getContents();
                    break block20;
lbl23:
                    // 1 sources

                    if (input instanceof IStorageEditorInput) {
                        in = ((IStorageEditorInput)input).getStorage().getContents();
                    } else {
                        throw new PartInitException("Invalid Input: Must be IFileEditorInput or FileStoreEditorInput");
                    }
                }
                if (!this.isRefresh) {
                    this.getJrContext(file);
                    this.xml2model(in);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.setModel(null);
                    throw new PartInitException("error closing input stream", (Throwable)e);
                }
            }
        }
    }

    private void closeEditor() {
        IWorkbenchPage apage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (apage = activeWorkbenchWindow.getActivePage()) != null) {
            Display.getDefault().asyncExec(() -> {
                this.closing = true;
                apage.closeEditor((IEditorPart)this, false);
            });
        }
    }

    public void setModel(INode model) {
        if (model == this.model) {
            return;
        }
        if (this.model != null && this.model.getChildren() != null && !this.model.getChildren().isEmpty()) {
            this.model.getChildren().get(0).getPropertyChangeSupport().addPropertyChangeListener(this.modelPropertyChangeListener);
        }
        if (model != null && model.getChildren() != null && !model.getChildren().isEmpty()) {
            model.getChildren().get(0).getPropertyChangeSupport().addPropertyChangeListener(this.modelPropertyChangeListener);
        }
        this.model = model;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            if (this.outlinePage == null) {
                this.outlinePage = new MultiOutlineView((EditorPart)this);
            }
            Display.getDefault().syncExec(new Runnable(){
                private boolean isUpdateOutline = false;

                @Override
                public void run() {
                    if (this.isUpdateOutline) {
                        this.isUpdateOutline = true;
                        AMultiEditor.this.updateContentOutline(AMultiEditor.this.getActivePage());
                        this.isUpdateOutline = false;
                    }
                }
            });
            return this.outlinePage;
        }
        return super.getAdapter(type);
    }

    private void updateContentOutline(int page) {
        if (this.outlinePage == null) {
            return;
        }
        Object outline = (IContentOutlinePage)this.getEditor(page).getAdapter(IContentOutlinePage.class);
        if (outline == null) {
            outline = new EmptyOutlinePage();
        }
        this.outlinePage.setPageActive((IContentOutlinePage)outline);
    }

    protected void createPageXML() {
        try {
            this.xmlEditor = new XMLEditor(this.jrContext);
            int index = this.addPage((IEditorPart)this.xmlEditor, this.getEditorInput());
            this.setPageText(index, Messages.common_source);
            this.xmlEditor.getDocumentProvider().getDocument((Object)this.xmlEditor.getEditorInput()).addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    AMultiEditor.this.xmlFresh = false;
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
            this.xmlEditor.getDocumentProvider().addElementStateListener((IElementStateListener)new StateListener());
        }
        catch (PartInitException e) {
            UIUtils.showError((Throwable)e);
        }
    }

    public static void refresh(JasperReportsContext jrContext) {
        Object obj = jrContext.getValue(THEEDITOR);
        if (obj instanceof JrxmlEditor) {
            ReportContainer rc = (ReportContainer)((JrxmlEditor)obj).getEditor(0);
            if (rc != null) {
                AMultiEditor.refresh(rc.getActiveEditor());
            }
        } else if (obj instanceof AMultiEditor) {
            AMultiEditor.refresh(((AMultiEditor)obj).getActiveEditor());
        }
    }

    public static void refresh(IEditorPart ep) {
        if (ep == null) {
            return;
        }
        if (ep instanceof IGraphicalEditor) {
            IGraphicalEditor ige = (IGraphicalEditor)ep;
            GraphicalViewer gv = ige.getGraphicalViewer();
            gv.getContents().refresh();
        }
    }

    public static void refreshElement(JasperReportsContext jrContext, PropertyChangeEvent event) {
        Object obj = jrContext.getValue(THEEDITOR);
        if (obj instanceof JrxmlEditor) {
            ReportContainer rc = (ReportContainer)((JrxmlEditor)obj).getEditor(0);
            if (rc != null) {
                AMultiEditor.refreshElement(rc.getActiveEditor(), event);
            }
        } else if (obj instanceof AMultiEditor) {
            AMultiEditor.refreshElement(((AMultiEditor)obj).getActiveEditor(), event);
        }
    }

    public static void refreshElement(IEditorPart ep, PropertyChangeEvent event) {
        if (ep == null) {
            return;
        }
        if (ep instanceof IGraphicalEditor) {
            IGraphicalEditor ige = (IGraphicalEditor)ep;
            GraphicalViewer gv = ige.getGraphicalViewer();
            EditPart editor = gv.getContents();
            if (editor instanceof ReportPageEditPart) {
                ((ReportPageEditPart)editor).propertyChange(event);
            } else {
                editor.refresh();
            }
        }
    }

    private final class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private ModelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AMultiEditor.this.getSite().getWorkbenchWindow().getShell().getDisplay().asyncExec(() -> AMultiEditor.this.firePropertyChange(257));
        }
    }

    private class StateListener
    implements IElementStateListener {
        private StateListener() {
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public void elementContentReplaced(Object element) {
        }

        public void elementDeleted(Object element) {
            Display.getDefault().asyncExec(() -> {
                boolean bl = AMultiEditor.this.getSite().getPage().closeEditor((IEditorPart)AMultiEditor.this, false);
            });
        }

        public void elementMoved(Object originalElement, Object movedElement) {
        }
    }
}

