/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.JRXMLUtils;
import java.io.InputStream;
import java.net.URI;
import net.sf.jasperreports.eclipse.builder.JSSReportContext;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class JasperFileEditorLauncher
implements IEditorLauncher {
    public void open(IPath file) {
        IFile jasperFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (jasperFile == null) {
            try {
                jasperFile = FileUtils.getInProjectFile((URI)file.toFile().toURI(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                UIUtils.showError((String)Messages.JasperFileEditorLauncher_ErrorExternalJasperFile, (Throwable)e);
            }
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IFile jrxmlFile = this.silentlyConvertJasperFile(jasperFile, (IProgressMonitor)new NullProgressMonitor());
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)jrxmlFile);
        }
        catch (PartInitException e) {
            UIUtils.showError((String)Messages.JasperFileEditorLauncher_ErrorWorkspaceJasperFile, (Throwable)e);
        }
    }

    private IFile silentlyConvertJasperFile(IFile jasperFile, IProgressMonitor monitor) {
        JSSReportContext jrContext = JSSReportContext.getNewConfig((IResource)jasperFile);
        IPath tmpPath = jasperFile.getFullPath().removeFileExtension();
        tmpPath = tmpPath.addFileExtension("jrxml");
        IFile jrxmlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(tmpPath);
        if (jrxmlFile.exists()) {
            boolean overwriteAnswer = MessageDialog.openQuestion((Shell)UIUtils.getShell(), (String)Messages.AbstractJRXMLEditor_ConversionTitle, (String)Messages.AbstractJRXMLEditor_ConversionMessage);
            if (overwriteAnswer) {
                try {
                    InputStream contents = jasperFile.getContents();
                    InputStream jrxmlInStream = JRXMLUtils.getJRXMLInputStream((JasperReportsContext)jrContext, contents, "jasper", "UTF-8", "last");
                    jrxmlFile.setContents(jrxmlInStream, 1, monitor);
                    jrxmlFile.getProject().refreshLocal(2, monitor);
                }
                catch (CoreException e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
                catch (JRException e) {
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
        } else {
            try {
                InputStream contents = jasperFile.getContents();
                InputStream jrxmlInStream = JRXMLUtils.getJRXMLInputStream((JasperReportsContext)jrContext, contents, "jasper", "UTF-8", "last");
                jrxmlFile.create(jrxmlInStream, 1, monitor);
            }
            catch (CoreException e) {
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
            catch (JRException e) {
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        return jrxmlFile;
    }
}

