/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.IJROBjectEditor;
import com.jaspersoft.studio.editor.TemplateStyleVisitor;
import com.jaspersoft.studio.editor.preview.view.control.VErrorPreview;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.CommonSelectionCacheProvider;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.util.ReportFactory;
import java.util.Set;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class JrxmlEditor
extends AbstractJRXMLEditor
implements IJROBjectEditor,
CachedSelectionProvider {
    private ReportContainer reportContainer;
    public static final String JRXML_EDITOR_ID = "com.jaspersoft.studio.editor.JrxmlEditor";

    @Override
    protected void createDesignEditorPage() throws PartInitException {
        this.reportContainer = new ReportContainer((EditorPart)this, this.jrContext);
        this.reportContainer.addPageChangedListener(event -> this.updateContentOutline(this.getActivePage()));
        int index = this.addPage((IEditorPart)this.reportContainer, this.getEditorInput());
        this.setPageText(index, Messages.JrxmlEditor_design);
    }

    public ReportContainer getReportContainer() {
        return this.reportContainer;
    }

    @Override
    protected String getEditorHelpID() {
        return "com.jaspersoft.studio.doc.editor_jrxml";
    }

    @Override
    public IEditorPart getActiveInnerEditor() {
        IEditorPart iep = this.getActiveEditor();
        if (iep instanceof ReportContainer) {
            return ((ReportContainer)iep).getActiveEditor();
        }
        return iep;
    }

    @Override
    public void updateVisualView() {
        if (this.reportContainer != null) {
            this.reportContainer.setModel(this.getModel());
        }
    }

    @Override
    public void gotoMarker(IMarker marker) {
        if (this.activePage == 0) {
            try {
                Object expr = marker.getAttribute("MARKER_ERROR_JREXPRESSION");
                if (expr != null && expr instanceof String) {
                    JRDesignExpression expression = new JRDesignExpression();
                    expression.setId(new Integer((String)expr).intValue());
                    JasperDesign jd = this.getJasperDesign();
                    JRExpressionCollector rc = JRExpressionCollector.collector((JasperReportsContext)this.jrContext, (JRReport)jd);
                    if (!VErrorPreview.openExpressionEditor(this.jrContext, rc, (JRDesignDataset)jd.getMainDataset(), expression)) {
                        for (JRDataset d : jd.getDatasetsList()) {
                            if (!VErrorPreview.openExpressionEditor(this.jrContext, rc, (JRDesignDataset)d, expression)) continue;
                            return;
                        }
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.setActivePage(1);
        IDE.gotoMarker((IEditorPart)this.xmlEditor, (IMarker)marker);
    }

    @Override
    public void openEditor(Object obj, ANode node) {
        this.reportContainer.openEditor(obj, node);
    }

    public void refreshExternalStyles(Set<String> removedStyles) {
    }

    public Image getTitleImage() {
        if (this.getCurrentFile() != null && "jrxml".equals(this.getCurrentFile().getFileExtension())) {
            return JaspersoftStudioPlugin.getInstance().getImage("icons/jrxml_icon.png");
        }
        return super.getTitleImage();
    }

    @Override
    public CommonSelectionCacheProvider getSelectionCache() {
        return this.reportContainer.getSelectionCache();
    }

    @Override
    protected boolean isDesignerDirty() {
        return this.reportContainer.isDirty();
    }

    @Override
    protected ISelection getDesignerPageSelection() {
        return this.reportContainer.getActiveEditor().getSite().getSelectionProvider().getSelection();
    }

    @Override
    protected void setDesignerPageSelection(ISelection newSelection) {
        this.reportContainer.getActiveEditor().getSite().getSelectionProvider().setSelection(newSelection);
    }

    @Override
    protected EditorPart getDesignEditor() {
        return this.reportContainer;
    }

    @Override
    protected INode createEditorModel() {
        return ReportFactory.createReport(this.jrContext);
    }

    @Override
    protected void editorVisible() {
        super.editorActivated();
        IEditorPart part = this.getActiveInnerEditor();
        if (part instanceof AbstractVisualEditor) {
            ((AbstractVisualEditor)part).getRuler().layout(true);
        }
    }

    @Override
    public void resourceChanged(final IResourceChangeEvent event) {
        super.resourceChanged(event);
        if (this.isRefreshing) {
            return;
        }
        if (this.getModel() != null && event.getType() == 1) {
            Job job = new Job("Verify Styles"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        TemplateStyleVisitor visitor = new TemplateStyleVisitor(JrxmlEditor.this);
                        event.getDelta().accept((IResourceDeltaVisitor)visitor);
                    }
                    catch (CoreException e) {
                        UIUtils.showError((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
    }
}

