/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.background.BackgroundMenuContributior;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.action.snap.SnapToGridAction;
import com.jaspersoft.studio.editor.gef.ui.actions.RZoomComboContributionItem;
import com.jaspersoft.studio.editor.preview.PreviewJRPrint;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.CachedSelectionProvider;
import com.jaspersoft.studio.editor.report.ReportContainer;
import com.jaspersoft.studio.editor.report.SelectionChangedListener;
import com.jaspersoft.studio.editor.xml.XMLEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.toolbars.CommonToolbarHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DeleteRetargetAction;
import org.eclipse.gef.ui.actions.RedoRetargetAction;
import org.eclipse.gef.ui.actions.UndoRetargetAction;
import org.eclipse.gef.ui.actions.ZoomInRetargetAction;
import org.eclipse.gef.ui.actions.ZoomOutRetargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class JrxmlEditorContributor
extends MultiPageEditorActionBarContributor {
    private List<String> globalActionKeys = new ArrayList<String>();
    private List<RetargetAction> retargetActions = new ArrayList<RetargetAction>();
    private ActionRegistry registry = new ActionRegistry();
    private RZoomComboContributionItem zoomCombo;
    private SelectionChangedListener selectionListener;
    private PartListener partListener = new PartListener();
    private List<String> glRetargetAction = new ArrayList<String>();
    private IEditorPart lastEditor;
    private TextEditorActionContributor textEditorContributor = null;

    public void init(IActionBars bars) {
        this.buildActions(bars);
        this.declareGlobalActionKeys();
        super.init(bars);
        this.getPage().addPartListener((IPartListener2)this.partListener);
    }

    protected void buildActions(IActionBars bars) {
        this.addRetargetAction((RetargetAction)new UndoRetargetAction());
        this.addRetargetAction((RetargetAction)new RedoRetargetAction());
        this.addRetargetAction((RetargetAction)new DeleteRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomInRetargetAction());
        this.addRetargetAction((RetargetAction)new ZoomOutRetargetAction());
        this.addRetargetAction(new RetargetAction("org.eclipse.gef.toggle_ruler_visibility", Messages.JrxmlEditorContributor_show_ruler, 2));
        this.addRetargetAction(new RetargetAction("PROPERTY_SNAP_TO_GUIDES_ENABLED", Messages.common_snap_to_guides, 2));
        this.addRetargetAction(new RetargetAction("org.eclipse.gef.toggle_grid_visibility", Messages.common_show_grid, 2));
        this.addRetargetAction(new RetargetAction("org.eclipse.gef.toggle_snapto_geometry", Messages.common_snap_to_geometry, 2));
        this.addRetargetAction(new RetargetAction(SnapToGridAction.ID, Messages.common_snap_to_grid, 2));
        this.addRetargetAction(new RetargetAction("sizegridaction", Messages.JrxmlEditorContributor_grid_size));
        List<RetargetAction> ractions = JaspersoftStudioPlugin.getDecoratorManager().buildMenuActions();
        for (RetargetAction r : ractions) {
            this.addRetargetAction(r);
        }
    }

    public void addRetargetAction(RetargetAction action) {
        this.addAction((IAction)action);
        this.retargetActions.add(action);
        this.getPage().addPartListener((IPartListener)action);
        this.addGlobalActionKey(action.getId());
    }

    protected void addGlobaRetargetAction(RetargetAction action) {
        this.addRetargetAction(action);
        this.glRetargetAction.add(action.getId());
    }

    protected void addGlobalActionKey(String key) {
        this.globalActionKeys.add(key);
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected ActionRegistry getActionRegistry() {
        return this.registry;
    }

    protected void declareGlobalActionKeys() {
        this.addGlobalActionKey(ActionFactory.PRINT.getId());
        this.addGlobalActionKey(ActionFactory.CUT.getId());
        this.addGlobalActionKey(ActionFactory.COPY.getId());
        this.addGlobalActionKey(ActionFactory.PASTE.getId());
        this.addGlobalActionKey(ActionFactory.SELECT_ALL.getId());
        this.addGlobalActionKey(ActionFactory.DELETE.getId());
    }

    protected IAction getAction(String id) {
        if (this.getActionRegistry() != null) {
            return this.getActionRegistry().getAction((Object)id);
        }
        return null;
    }

    public void setActivePage(IEditorPart activeEditor) {
        ActionRegistry registry;
        if (!(activeEditor instanceof ReportContainer)) {
            CommonToolbarHandler.clearToolbars(this.getActionBars());
        } else {
            CommonToolbarHandler.updateSelection(activeEditor, this.getActionBars());
        }
        if (this.lastEditor instanceof CachedSelectionProvider && this.selectionListener != null) {
            ((CachedSelectionProvider)this.lastEditor).getSelectionCache().removeSelectionChangeListener(this.selectionListener);
        }
        IActionBars bars = this.getActionBars();
        this.removeZoom(bars.getToolBarManager());
        bars.clearGlobalActionHandlers();
        this.lastEditor = activeEditor;
        this.addGlobal(bars);
        if (activeEditor instanceof XMLEditor) {
            if (this.textEditorContributor == null) {
                this.textEditorContributor = new TextEditorActionContributor();
                this.textEditorContributor.init(bars, activeEditor.getSite().getPage());
            }
            this.textEditorContributor.setActiveEditor(activeEditor);
        } else if (activeEditor instanceof ReportContainer || activeEditor instanceof AbstractVisualEditor) {
            ActionRegistry registry2;
            GraphicalViewer graphicalViewer;
            ZoomManager property;
            if (activeEditor instanceof AbstractVisualEditor && (property = (ZoomManager)(graphicalViewer = ((AbstractVisualEditor)activeEditor).getGraphicalViewer()).getProperty(ZoomManager.class.toString())) != null) {
                this.zoomCombo.setZoomManager(property);
            }
            if ((registry2 = (ActionRegistry)activeEditor.getAdapter(ActionRegistry.class)) != null) {
                Iterator actions;
                for (String id : this.globalActionKeys) {
                    bars.setGlobalActionHandler(id, registry2.getAction((Object)id));
                }
                Iterator it = actions = registry2.getActions();
                while (it.hasNext()) {
                    IAction action = (IAction)it.next();
                    if (!(action instanceof IGlobalAction)) continue;
                    bars.setGlobalActionHandler(action.getId(), action);
                }
            }
            ((CachedSelectionProvider)this.lastEditor).getSelectionCache().addSelectionChangeListener(this.getSelectionChangeListener(registry2));
        } else if (activeEditor instanceof PreviewJRPrint && (registry = (ActionRegistry)activeEditor.getAdapter(ActionRegistry.class)) != null) {
            Iterator actions;
            for (String id : this.globalActionKeys) {
                bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            }
            Iterator it = actions = registry.getActions();
            while (it.hasNext()) {
                IAction action = (IAction)it.next();
                if (!(action instanceof IGlobalAction)) continue;
                bars.setGlobalActionHandler(action.getId(), action);
            }
        }
        bars.updateActionBars();
    }

    public IEditorPart getLastEditor() {
        return this.lastEditor;
    }

    private SelectionChangedListener getSelectionChangeListener(ActionRegistry registry) {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionChangedListener(){

                @Override
                public void selectionChanged() {
                    UIUtils.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (JrxmlEditorContributor.this.getPage() != null && JrxmlEditorContributor.this.getPage().getActiveEditor() != null) {
                                CommonToolbarHandler.updateSelection(JrxmlEditorContributor.this.getPage().getActiveEditor(), JrxmlEditorContributor.this.getActionBars());
                            }
                        }
                    });
                }
            };
        }
        return this.selectionListener;
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add(this.getAction(ActionFactory.UNDO.getId()));
        tbm.add(this.getAction(ActionFactory.REDO.getId()));
        tbm.add((IContributionItem)new Separator());
        this.addZoom(tbm);
    }

    private void addZoom(IToolBarManager tbm) {
        tbm.add(this.getAction("org.eclipse.gef.zoom_in"));
        tbm.add(this.getAction("org.eclipse.gef.zoom_out"));
        if (this.zoomCombo == null) {
            this.zoomCombo = new RZoomComboContributionItem();
        }
        this.zoomCombo.setEnabled(true);
        tbm.add((IContributionItem)this.zoomCombo);
        tbm.update(true);
    }

    private void removeZoom(IToolBarManager tbm) {
        tbm.remove("org.eclipse.gef.zoom_in");
        tbm.remove("org.eclipse.gef.zoom_out");
        tbm.remove(this.zoomCombo.getId());
        this.zoomCombo.setEnabled(false);
        tbm.update(true);
    }

    private void addGlobal(IActionBars bars) {
        IToolBarManager tbm = bars.getToolBarManager();
        for (String s : this.glRetargetAction) {
            tbm.remove(s);
            tbm.add(this.getAction(s));
        }
        tbm.update(true);
    }

    public void contributeToMenu(IMenuManager manager) {
        super.contributeToMenu(manager);
        MenuManager viewMenu = new MenuManager(Messages.JrxmlEditorContributor_view);
        viewMenu.add(this.getAction("org.eclipse.gef.zoom_in"));
        viewMenu.add(this.getAction("org.eclipse.gef.zoom_out"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)BackgroundMenuContributior.getBackgroundMenu());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add(this.getAction("org.eclipse.gef.toggle_ruler_visibility"));
        viewMenu.add(this.getAction("PROPERTY_SNAP_TO_GUIDES_ENABLED"));
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add(this.getAction("org.eclipse.gef.toggle_grid_visibility"));
        viewMenu.add(this.getAction(SnapToGridAction.ID));
        viewMenu.add(this.getAction("org.eclipse.gef.toggle_snapto_geometry"));
        viewMenu.add(this.getAction("sizegridaction"));
        JaspersoftStudioPlugin.getDecoratorManager().contribute2Menu(this.getActionRegistry(), viewMenu);
        manager.insertAfter("edit", (IContributionItem)viewMenu);
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        if (this.textEditorContributor != null) {
            this.textEditorContributor.contributeToStatusLine(statusLineManager);
        }
        statusLineManager.setMessage("");
    }

    public void dispose() {
        this.getPage().removePartListener((IPartListener2)this.partListener);
        for (RetargetAction action : this.retargetActions) {
            this.getPage().removePartListener((IPartListener)action);
            action.dispose();
        }
        this.registry.dispose();
        this.retargetActions = null;
        this.registry = null;
    }

    private final class PartListener
    implements IPartListener2 {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IEditorPart activeEditor = partRef.getPage().getActiveEditor();
            if (activeEditor instanceof AbstractJRXMLEditor) {
                activeEditor = ((AbstractJRXMLEditor)activeEditor).getActiveEditor();
            }
            JrxmlEditorContributor.this.setActivePage(activeEditor);
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (JrxmlEditorContributor.this.lastEditor instanceof CachedSelectionProvider && JrxmlEditorContributor.this.selectionListener != null) {
                ((CachedSelectionProvider)JrxmlEditorContributor.this.lastEditor).getSelectionCache().selectionChanged((ISelection)StructuredSelection.EMPTY);
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

