/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.AbstractJRXMLEditor;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.preview.view.control.JRErrorHandler;
import com.jaspersoft.studio.editor.preview.view.control.JRMarkerErrorHandler;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.Console;
import com.jaspersoft.studio.utils.SelectionHelper;
import com.jaspersoft.studio.utils.SubreportsUtil;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.File;
import java.text.MessageFormat;
import java.util.Map;
import net.sf.jasperreports.eclipse.builder.JasperReportErrorHandler;
import net.sf.jasperreports.eclipse.builder.JasperReportsBuilder;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class CompileAction
extends SelectionAction
implements IMenuCreator {
    public static final String ID = "compileAction";
    private Menu menu;

    public CompileAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(false);
        this.setMenuCreator(this);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CompileAction_actionName);
        this.setToolTipText(Messages.CompileAction_actionTooltip);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("/icons/build_tab.gif"));
        this.setId(ID);
        this.setEnabled(true);
    }

    public void run() {
        final JasperReportsConfiguration jConfig = this.getMDatasetToShow();
        final Console console = this.getCleanConsole();
        if (jConfig != null) {
            Job job = new Job(Messages.CompileAction_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    IEditorPart editor;
                    SubMonitor subM = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    IWorkbenchPart part = CompileAction.this.getWorkbenchPart();
                    if (part != null && part.getSite() != null && part.getSite().getPage() != null && part.getSite().getPage().getActiveEditor() != null && (editor = part.getSite().getPage().getActiveEditor()) instanceof ISaveablePart && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)subM.split(5));
                    }
                    subM.setWorkRemaining(5);
                    IStatus status = CompileAction.this.actionCompile(jConfig, (IProgressMonitor)subM.split(95), true, console);
                    return status;
                }
            };
            job.setPriority(40);
            job.schedule();
        }
    }

    public IStatus actionCompile(JasperReportsConfiguration jConfig, IProgressMonitor monitor, boolean compileMain, final Console console) {
        IFile mfile = (IFile)jConfig.get("ifile");
        if (mfile != null) {
            try {
                if (console != null) {
                    console.addMessage(MessageFormat.format(Messages.CompileAction_consoleMessage1, mfile.getName()));
                }
                JasperReportsBuilder builder = new JasperReportsBuilder(){

                    protected JasperReportErrorHandler getErrorHandler(IFile resource) {
                        JRMarkerErrorHandler errorHandler = new JRMarkerErrorHandler(console, resource);
                        ((JRErrorHandler)errorHandler).reset();
                        return errorHandler;
                    }
                };
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (compileMain) {
                    monitor.subTask(Messages.CompileAction_SubtaskCompilingMainReport);
                    IFile destFIle = builder.compileJRXML((IResource)mfile, (IProgressMonitor)submon.split(10), (SimpleJasperReportsContext)jConfig);
                    if (console != null && destFIle != null) {
                        File file = destFIle.getRawLocation().toFile();
                        if (file.exists()) {
                            console.addMessage(MessageFormat.format(Messages.CompileAction_consoleMessage2, file.toString()));
                        } else {
                            console.addMessage(Messages.CompileAction_consoleMessage3);
                        }
                    }
                }
                submon.setWorkRemaining(90);
                monitor.subTask(Messages.CompileAction_SubtaskRetrievingAllSubs);
                Map<File, IFile> fmap = this.getSubreports(jConfig, mfile, jConfig.getJasperDesign(), (IProgressMonitor)submon.split(80));
                monitor.subTask(Messages.CompileAction_SubtaskCompilingAllSubs);
                SubMonitor subcompileMon = submon.split(10).setWorkRemaining(fmap.size());
                for (File f : fmap.keySet()) {
                    IFile file = fmap.get(f);
                    if (file != null) {
                        builder.compileJRXML((IResource)file, (IProgressMonitor)subcompileMon.split(1), (SimpleJasperReportsContext)jConfig);
                        continue;
                    }
                    try {
                        JasperCompileManager.compileReportToFile((String)f.getAbsolutePath());
                    }
                    catch (JRException e) {
                        e.printStackTrace();
                    }
                }
                submon.setWorkRemaining(0);
            }
            catch (CoreException coreException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    protected Map<File, IFile> getSubreports(JasperReportsConfiguration jConfig, IFile mfile, JasperDesign jd, IProgressMonitor monitor) {
        return SubreportsUtil.getSubreportFiles(jConfig, mfile, jConfig.getJasperDesign(), monitor);
    }

    protected Console getCleanConsole() {
        AbstractJRXMLEditor editor = (AbstractJRXMLEditor)SelectionHelper.getActiveJRXMLEditor();
        if (editor != null) {
            final Console console = editor.getConsole();
            if (console != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        console.clearConsole();
                    }
                });
            }
            return editor.getConsole();
        }
        return null;
    }

    protected JasperReportsConfiguration getMDatasetToShow() {
        Object firstElement;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof EditPart && ((EditPart)firstElement).getModel() instanceof ANode) {
            ANode currentNode = (ANode)((EditPart)firstElement).getModel();
            return currentNode.getJasperConfiguration();
        }
        AbstractVisualEditor part = (AbstractVisualEditor)this.getWorkbenchPart();
        if (part instanceof ReportEditor) {
            ReportEditor rpeditor = (ReportEditor)part;
            return rpeditor.getJrContext();
        }
        if (!part.getModel().getChildren().isEmpty()) {
            ANode firstChild = (ANode)part.getModel().getChildren().get(0);
            return firstChild.getJasperConfiguration();
        }
        IEditorPart activeJRXMLEditor = SelectionHelper.getActiveJRXMLEditor();
        if (activeJRXMLEditor != null && activeJRXMLEditor instanceof JrxmlEditor) {
            JrxmlEditor jrEditor = (JrxmlEditor)activeJRXMLEditor;
            return ((ANode)jrEditor.getModel()).getJasperConfiguration();
        }
        return null;
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public static IStatus doRun(JasperReportsConfiguration jConfig, IProgressMonitor monitor, boolean compileMain) {
        IFile mfile = (IFile)jConfig.get("ifile");
        if (mfile != null) {
            try {
                SubMonitor submon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                JasperReportsBuilder builder = new JasperReportsBuilder();
                if (compileMain) {
                    monitor.subTask(Messages.CompileAction_SubtaskCompilingMainReport);
                    builder.compileJRXML((IResource)mfile, (IProgressMonitor)submon.split(10), (SimpleJasperReportsContext)jConfig);
                }
                submon.setWorkRemaining(90);
                monitor.subTask(Messages.CompileAction_SubtaskRetrievingAllSubs);
                Map<File, IFile> fmap = SubreportsUtil.getSubreportFiles(jConfig, mfile, jConfig.getJasperDesign(), (IProgressMonitor)submon.split(80));
                monitor.subTask(Messages.CompileAction_SubtaskCompilingAllSubs);
                SubMonitor subcompileMon = submon.split(10).setWorkRemaining(fmap.size());
                for (File f : fmap.keySet()) {
                    IFile file = fmap.get(f);
                    if (file != null) {
                        builder.compileJRXML((IResource)file, (IProgressMonitor)subcompileMon.split(1), (SimpleJasperReportsContext)jConfig);
                    } else {
                        try {
                            JasperCompileManager.compileReportToFile((String)f.getAbsolutePath());
                        }
                        catch (JRException e) {
                            e.printStackTrace();
                        }
                    }
                    if (monitor.isCanceled()) break;
                }
                submon.setWorkRemaining(0);
            }
            catch (CoreException coreException) {
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = new Menu(parent);
        MenuItem manage = new MenuItem(this.menu, 8);
        manage.setText(Messages.CompileAction_manage);
        manage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog pref;
                JasperReportsConfiguration jConfig = CompileAction.this.getMDatasetToShow();
                IFile f = (IFile)jConfig.get("ifile");
                if (f != null && (pref = PreferencesUtil.createPropertyDialogOn((Shell)UIUtils.getShell(), (IAdaptable)f.getProject(), (String)"com.jaspersoft.studio.backward.JRVersionPreferencesPages.property", null, null)) != null) {
                    pref.open();
                }
            }
        });
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

