/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.EncloseIntoFrameCommand;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class EncloseIntoFrameAction
extends ACachedSelectionAction {
    public static final String ID = "EncloseIntoFrame";

    public EncloseIntoFrameAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.EncloseIntoFrameAction_actionTitle);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/enclose_into_frame.png"));
        this.setEnabled(false);
    }

    @Override
    protected Command createCommand() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (mGraphElements.isEmpty()) {
            return null;
        }
        ANode parentCheck = ((MGraphicElement)mGraphElements.get(0)).getParent();
        EncloseIntoFrameCommand command = new EncloseIntoFrameCommand(parentCheck);
        for (Object rawNode : mGraphElements) {
            MGraphicElement node = (MGraphicElement)rawNode;
            if (parentCheck == node.getParent()) {
                command.addNode(node);
                continue;
            }
            return null;
        }
        return command;
    }
}

