/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.SimpleJRXMLEditor;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.report.ReportEditor;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.band.MBand;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class HideElementsAction
extends ACachedSelectionAction {
    public static final String ID_VISIBLE = "setVisibilityAction_visible";
    public static final String ID_NOT_VISIBLE = "setVisibilityAction_notVisible";
    private boolean makeVisible = true;

    public HideElementsAction(IWorkbenchPart part, boolean makeVisible) {
        super(part);
        this.setLazyEnablementCalculation(false);
        this.makeVisible = makeVisible;
        this.init();
    }

    protected void init() {
        super.init();
        if (this.makeVisible) {
            this.setText(Messages.HideElementsAction_showTitle);
            this.setToolTipText(Messages.HideElementsAction_showTooltip);
            this.setId(ID_VISIBLE);
            this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/show.png"));
        } else {
            this.setText(Messages.HideElementsAction_hideTitle);
            this.setToolTipText(Messages.HideElementsAction_hideTooltip);
            this.setId(ID_NOT_VISIBLE);
            this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/hide.png"));
        }
        this.setEnabled(false);
    }

    private void updateActions() {
        SimpleJRXMLEditor jrxmlEditor;
        IEditorPart part;
        IEditorPart editor = SelectionHelper.getActiveJRXMLEditor();
        if (editor instanceof JrxmlEditor) {
            JrxmlEditor jrxmlEditor2 = (JrxmlEditor)editor;
            IEditorPart part2 = jrxmlEditor2.getReportContainer().getActiveEditor();
            if (part2 instanceof ReportEditor) {
                ((ReportEditor)part2).forceUpdateActions();
            }
        } else if (editor instanceof SimpleJRXMLEditor && (part = (jrxmlEditor = (SimpleJRXMLEditor)editor).getReportContainer().getActiveEditor()) instanceof ReportEditor) {
            ((ReportEditor)part).forceUpdateActions();
        }
    }

    @Override
    protected Command createCommand() {
        List<Object> bands = this.editor.getSelectionCache().getSelectionModelForType(MBand.class);
        if (!bands.isEmpty()) {
            JSSCompoundCommand visibilityCommands = new JSSCompoundCommand((ANode)bands.get(0));
            for (Object rawBand : bands) {
                MBand band = (MBand)rawBand;
                if (band.isVisible() == this.makeVisible || band.getValue() == null) continue;
                visibilityCommands.add(new SetVisibilityCommand(band, this.makeVisible));
            }
            return visibilityCommands.isEmpty() ? null : visibilityCommands;
        }
        return null;
    }

    private class SetVisibilityCommand
    extends Command {
        private MBand band;
        private boolean newVisibilityValue;

        public SetVisibilityCommand(MBand band, boolean newVisibilityValue) {
            this.band = band;
            this.newVisibilityValue = newVisibilityValue;
        }

        private void recursiveVisibility(List<INode> children, boolean visibility) {
            for (INode child : children) {
                if (child instanceof MGraphicElement) {
                    ((MGraphicElement)child).setVisible(visibility);
                }
                this.recursiveVisibility(child.getChildren(), visibility);
            }
        }

        public void execute() {
            this.recursiveVisibility(this.band.getChildren(), this.newVisibilityValue);
            this.band.setVisible(this.newVisibilityValue);
            this.band.getPropertyChangeSupport().firePropertyChange("refreshUIEvent", null, null);
            HideElementsAction.this.updateActions();
        }

        public void undo() {
            this.recursiveVisibility(this.band.getChildren(), !this.newVisibilityValue);
            this.band.setVisible(!this.newVisibilityValue);
            this.band.getPropertyChangeSupport().firePropertyChange("refreshUIEvent", null, null);
            HideElementsAction.this.updateActions();
        }
    }
}

