/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.action.SetWorkbenchAction;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.band.MBandGroupFooter;
import com.jaspersoft.studio.model.band.MBandGroupHeader;
import com.jaspersoft.studio.model.group.MGroup;
import com.jaspersoft.studio.model.group.command.CreateGroupCommand;
import com.jaspersoft.studio.model.group.command.DeleteGroupCommand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class MoveGroupUpAction
extends SetWorkbenchAction
implements IGlobalAction {
    public static final String ID = "move_group_up";

    public MoveGroupUpAction(IWorkbenchPart part) {
        super(part);
    }

    protected boolean calculateEnabled(List<?> editparts) {
        List<APropertyNode> selection = this.getOperationSet(editparts);
        if (selection.size() == 1) {
            APropertyNode groupNode = this.getOperationSet(editparts).get(0);
            MGroup groupElement = null;
            if (groupNode instanceof MBandGroupHeader) {
                groupElement = ((MBandGroupHeader)groupNode).getMGroup();
            } else if (groupNode instanceof MBandGroupFooter) {
                groupElement = ((MBandGroupFooter)groupNode).getMGroup();
            }
            List groupList = groupNode.getJasperDesign().getGroupsList();
            int index = groupList.indexOf(groupElement.getValue());
            return index > 0;
        }
        return false;
    }

    public boolean calculateEnabled(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return this.calculateEnabled(((IStructuredSelection)selection).toList());
        }
        return false;
    }

    protected boolean calculateEnabled() {
        return this.calculateEnabled(this.getSelectedObjects());
    }

    protected List<APropertyNode> getOperationSet(List<?> editparts) {
        if (editparts.isEmpty()) {
            return new ArrayList<APropertyNode>();
        }
        ArrayList<APropertyNode> result = new ArrayList<APropertyNode>();
        for (Object element : editparts) {
            EditPart part;
            if (!(element instanceof EditPart) || !((part = (EditPart)element).getModel() instanceof MBandGroupHeader) && !(part.getModel() instanceof MBandGroupFooter)) continue;
            result.add((APropertyNode)((EditPart)element).getModel());
            break;
        }
        return result;
    }

    private void setSelection(EditPart parent, APropertyNode groupNode) {
        EditPart partToSelect = null;
        for (Object child : parent.getChildren()) {
            String actualGroupName;
            String groupName;
            EditPart part;
            if (!(child instanceof EditPart) || !(part = (EditPart)child).getModel().getClass().equals(groupNode.getClass()) || !(groupName = groupNode.getPropertyValue("name").toString()).equals(actualGroupName = ((APropertyNode)part.getModel()).getPropertyValue("name").toString())) continue;
            partToSelect = part;
            break;
        }
        if (partToSelect != null) {
            StructuredSelection newselection = new StructuredSelection(partToSelect);
            this.setSelection((ISelection)newselection);
            this.getWorkbenchPart().getSite().getSelectionProvider().setSelection((ISelection)newselection);
        }
    }

    public void execute(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.execute(((IStructuredSelection)selection).toList());
        }
    }

    public void execute(List<?> editparts) {
        EditPart selectionParent = ((EditPart)editparts.get(0)).getParent();
        APropertyNode groupNode = this.getOperationSet(editparts).get(0);
        JSSCompoundCommand cmd = new JSSCompoundCommand(groupNode);
        ANode groupElement = null;
        if (groupNode instanceof MBandGroupHeader) {
            cmd.add(new DeleteGroupCommand((MReport)groupNode.getParent(), (MBandGroupHeader)groupNode));
            groupElement = ((MBandGroupHeader)groupNode).getMGroup();
        } else if (groupNode instanceof MBandGroupFooter) {
            cmd.add(new DeleteGroupCommand((MReport)groupNode.getParent(), (MBandGroupFooter)groupNode));
            groupElement = ((MBandGroupFooter)groupNode).getMGroup();
        }
        int index = groupNode.getJasperDesign().getGroupsList().indexOf(groupElement.getValue());
        cmd.add(new CreateGroupCommand((MReport)groupNode.getParent(), (MGroup)groupElement, index - 1));
        this.execute((Command)cmd);
        this.setSelection(selectionParent, groupNode);
    }

    public void run() {
        ArrayList editparts = new ArrayList(this.getSelectedObjects());
        this.execute(editparts);
    }

    protected void init() {
        super.init();
        this.setText(Messages.MoveGroupUpAction_actionName);
        this.setToolTipText(Messages.MoveGroupUpAction_actionDescription);
        this.setId(ID);
        this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/arrow-group-up.png"));
        this.setEnabled(false);
    }
}

