/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.DataAdapterManager;
import com.jaspersoft.studio.data.storage.ADataAdapterStorage;
import com.jaspersoft.studio.data.storage.JRDefaultDataAdapterStorage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SelectDataAdapterAction
extends Action
implements IMenuCreator {
    private JasperReportsConfiguration jConfig;
    private DataAdapterDescriptor[] values = null;
    private String[] names = null;
    private Menu menu;
    public static final String ID = "SelectDataAdapterAction";

    private void initAvailableValues() {
        if (this.values == null) {
            IFile file = (IFile)this.jConfig.get("ifile");
            ADataAdapterStorage[] dastorages = DataAdapterManager.getDataAdapter(file, this.jConfig);
            ArrayList<String> namesList = new ArrayList<String>();
            ArrayList<DataAdapterDescriptor> valuesList = new ArrayList<DataAdapterDescriptor>();
            int i = 0;
            while (i < dastorages.length) {
                ADataAdapterStorage s = dastorages[i];
                for (DataAdapterDescriptor d : s.getDataAdapterDescriptors()) {
                    valuesList.add(d);
                    namesList.add(s.getLabel(d));
                }
                ++i;
            }
            this.values = valuesList.toArray(new DataAdapterDescriptor[valuesList.size()]);
            this.names = namesList.toArray(new String[namesList.size()]);
        }
    }

    private void createEmptyItem(Menu menu) {
        MenuItem item = new MenuItem(menu, 32);
        item.setText(" -- No Data Adapter -- ");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDataAdapterAction.this.jConfig.getJasperDesign().removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
            }
        });
    }

    public SelectDataAdapterAction(JasperReportsConfiguration jConfig) {
        this.setText(Messages.SelectDataAdapterAction_actionTitle);
        this.setId(ID);
        this.jConfig = jConfig;
        this.setEnabled(false);
    }

    public void setSelectedAdapter(DataAdapterDescriptor desc) {
        JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(this.jConfig);
        DataAdapterDescriptor defaultAdapter = defaultStorage.getDefaultJRDataAdapter((JRDesignDataset)null);
        if (defaultAdapter != null && defaultAdapter == desc) {
            this.jConfig.getJasperDesign().removeProperty("com.jaspersoft.studio.data.defaultdataadapter");
        } else {
            this.jConfig.getJasperDesign().setProperty("com.jaspersoft.studio.data.defaultdataadapter", desc.getName());
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        MenuItem root = new MenuItem(parent, 64);
        this.menu = new Menu(parent);
        root.setMenu(this.menu);
        root.setText(Messages.SelectDataAdapterAction_actionTitle);
        this.initAvailableValues();
        int i = 0;
        while (i < this.values.length) {
            DataAdapterDescriptor desc = this.values[i];
            MenuItem item = new MenuItem(this.menu, 32);
            item.setText(this.names[i]);
            item.setImage(JaspersoftStudioPlugin.getInstance().getImage(desc.getIcon16()));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object data = e.widget.getData();
                    if (data != null && data instanceof DataAdapterDescriptor) {
                        SelectDataAdapterAction.this.setSelectedAdapter((DataAdapterDescriptor)data);
                    }
                }
            });
            item.setData((Object)desc);
            ++i;
        }
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                String selectedtem = SelectDataAdapterAction.this.jConfig.getJasperDesign().getProperty("com.jaspersoft.studio.data.defaultdataadapter");
                if (selectedtem == null) {
                    JRDefaultDataAdapterStorage defaultStorage = DataAdapterManager.getJRDefaultStorage(SelectDataAdapterAction.this.jConfig);
                    DataAdapterDescriptor defaultAdapter = defaultStorage.getDefaultJRDataAdapter((JRDesignDataset)null);
                    MenuItem[] menuItemArray = SelectDataAdapterAction.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item;
                        item.setSelection((item = menuItemArray[n2]).getData() == defaultAdapter);
                        ++n2;
                    }
                } else {
                    MenuItem[] menuItemArray = SelectDataAdapterAction.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MenuItem item;
                        item.setSelection((item = menuItemArray[n3]).getData() != null && item.getData() instanceof DataAdapterDescriptor && ((DataAdapterDescriptor)item.getData()).getName().equals(selectedtem));
                        ++n3;
                    }
                }
            }
        });
        return this.menu;
    }

    public Menu getMenu(Control parent) {
        Menu rootMenu = new Menu(parent);
        this.getMenu(rootMenu);
        this.menu = rootMenu;
        return this.menu;
    }
}

