/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.spreadsheet.SpreadsheetLayout;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class UnBindElementsAction
extends ACachedSelectionAction {
    public static final String ID = "UnBindElements";

    public UnBindElementsAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        this.setText(Messages.UnBindElementsAction_name);
        this.setId(ID);
        this.setEnabled(false);
    }

    public boolean isEnabled() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        if (mGraphElements.isEmpty()) {
            return false;
        }
        for (Object rawNode : mGraphElements) {
            JRPropertiesHolder holder;
            ANode currentNode = (ANode)rawNode;
            ANode parentNode = currentNode.getParent();
            JRPropertiesHolder parentHolder = LayoutManager.getPropertyHolder(parentNode);
            if (parentHolder != null) {
                String parentLayout = parentHolder.getPropertiesMap().getProperty("com.jaspersoft.studio.layout");
                if (!SpreadsheetLayout.class.getName().equals(parentLayout)) {
                    return false;
                }
            }
            if ((holder = LayoutManager.getPropertyHolder(currentNode)).getPropertiesMap().containsProperty("com.jaspersoft.studio.spreadsheet.connectionID")) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        List<Object> mGraphElements = this.editor.getSelectionCache().getSelectionModelForType(MGraphicElement.class);
        MGraphicElement firstElement = (MGraphicElement)mGraphElements.get(0);
        JSSCompoundCommand cmd = new JSSCompoundCommand(firstElement);
        for (Object rawNode : mGraphElements) {
            MGraphicElement element = (MGraphicElement)rawNode;
            JRPropertiesMap map = element.getValue().getPropertiesMap();
            SetPropertyValueCommand setCmd = new SetPropertyValueCommand(map, "com.jaspersoft.studio.spreadsheet.connectionID", null);
            cmd.add(setCmd);
        }
        LayoutCommand layoutCommand = LayoutManager.createRelayoutCommand(firstElement.getParent());
        cmd.add(layoutCommand);
        SpreadsheetLayout.refreshCache(firstElement.getJasperDesign());
        this.command = cmd;
        this.fresh = true;
        super.run();
    }

    @Override
    protected Command createCommand() {
        return null;
    }
}

