/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.align;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.ToolUtilitiesCompatibility;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.IGlobalAction;
import com.jaspersoft.studio.editor.gef.commands.Align2ElementCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.MGraphicElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class Align2Element
extends ACachedSelectionAction
implements IGlobalAction {
    public static final String ID_ALIGN_BOTTOM = "org.eclipse.gef.align_bottom";
    public static final String ID_ALIGN_CENTER = "org.eclipse.gef.align_center";
    public static final String ID_ALIGN_LEFT = "org.eclipse.gef.align_left";
    public static final String ID_ALIGN_MIDDLE = "org.eclipse.gef.align_middle";
    public static final String ID_ALIGN_RIGHT = "org.eclipse.gef.align_right";
    public static final String ID_ALIGN_TOP = "org.eclipse.gef.align_top";
    private int alignment;

    public Align2Element(IWorkbenchPart part, int align) {
        super(part);
        this.alignment = align;
        this.initUI();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Command createCommand() {
        void var6_9;
        List<Object> editparts = this.editor.getSelectionCache().getSelectionModelPartForType(MGraphicElement.class);
        editparts = ToolUtilitiesCompatibility.getSelectionWithoutDependants(editparts);
        EditPart primary = this.getPrimary(editparts);
        if (editparts.size() < 2 || primary == null) {
            return null;
        }
        MGraphicElement primaryModel = (MGraphicElement)primary.getModel();
        JSSCompoundCommand command = new JSSCompoundCommand(primaryModel);
        ArrayList<MGraphicElement> selection = new ArrayList<MGraphicElement>();
        for (EditPart editPart : editparts) {
            selection.add((MGraphicElement)editPart.getModel());
        }
        command.setDebugLabel(this.getText());
        boolean bl = false;
        while (var6_9 < editparts.size()) {
            command.add(new Align2ElementCommand(this.alignment, primaryModel, selection));
            ++var6_9;
        }
        return command;
    }

    protected EditPart getPrimary(List<EditPart> editparts) {
        EditPart partialResult = null;
        for (EditPart part : editparts) {
            if (part.getModel() instanceof MGraphicElement && (partialResult = part).getSelected() == 2) break;
        }
        return partialResult;
    }

    protected void initUI() {
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(Messages.Align2Element_Align_To_Left);
                this.setToolTipText(Messages.Align2Element_Align_To_Left_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-left.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-left.gif"));
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(Messages.Align2Element_Align_To_Right);
                this.setToolTipText(Messages.Align2Element_Align_To_Right_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-right.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-right.gif"));
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(Messages.Align2Element_Align_To_Top);
                this.setToolTipText(Messages.Align2Element_Align_To_Top_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-top.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-top.gif"));
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(Messages.Align2Element_Align_To_Bottom);
                this.setToolTipText(Messages.Align2Element_Align_To_Bottom_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-bottom.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-bottom.gif"));
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(Messages.Align2Element_Align_To_Center);
                this.setToolTipText(Messages.Align2Element_Align_To_Center_tool_tip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-center.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-center.gif"));
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(Messages.Align2Element_Align_To_Middle);
                this.setToolTipText(Messages.Align2Element_Align_To_Middle_tooltip);
                this.setImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/align-middle.gif"));
                this.setDisabledImageDescriptor(JaspersoftStudioPlugin.getInstance().getImageDescriptor("icons/resources/eclipse/disabled/align-middle.gif"));
            }
        }
    }
}

