/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.copy.CopyCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CopyAction
extends ACachedSelectionAction {
    public CopyAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText(Messages.common_copy);
        this.setId(ActionFactory.COPY.getId());
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        this.execute(this.command);
    }

    private void getNestedElementsRecursive(INode elementToExplore, HashSet<INode> nestedFound) {
        List<INode> selectedObjects = elementToExplore.getChildren();
        for (INode element : selectedObjects) {
            if (element instanceof IContainer) {
                this.getNestedElementsRecursive(element, nestedFound);
            }
            nestedFound.add(element);
        }
    }

    private HashSet<INode> getNotNestedSelection(List<?> selectedObjects) {
        HashSet<INode> nestedElements = new HashSet<INode>();
        List<Object> containers = this.editor.getSelectionCache().getSelectionModelForType(IContainer.class);
        for (Object container : containers) {
            this.getNestedElementsRecursive((INode)container, nestedElements);
        }
        return nestedElements;
    }

    @Override
    protected Command createCommand() {
        List selectedObjects = this.getSelectedObjects();
        if (selectedObjects.isEmpty()) {
            return null;
        }
        CopyCommand cmd = new CopyCommand();
        HashSet<INode> nestedElements = this.getNotNestedSelection(selectedObjects);
        List<Object> copiableNodes = this.editor.getSelectionCache().getSelectionModelForType(ICopyable.class);
        for (Object node : copiableNodes) {
            if (nestedElements.contains(node)) continue;
            cmd.addElement((ICopyable)node);
        }
        return cmd;
    }

    protected void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        command.execute();
    }
}

