/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.editor.action.copy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.action.copy.CutCommand;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.ICopyable;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.style.MStyleTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CutAction
extends ACachedSelectionAction {
    public CutAction(IWorkbenchPart part) {
        super(part);
        this.setLazyEnablementCalculation(true);
    }

    protected void init() {
        super.init();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setText(Messages.common_cut);
        this.setId(ActionFactory.CUT.getId());
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setEnabled(false);
    }

    @Override
    public void run() {
        this.execute(this.createCommand());
    }

    private void addChildren(INode node, HashSet<INode> children) {
        for (INode child : node.getChildren()) {
            this.addChildren(child, children);
            children.add(child);
        }
    }

    private HashSet<INode> getNotNestedNodes(List<Object> copiedObjects) {
        HashSet<INode> nodesInHierarchy = new HashSet<INode>();
        for (Object node : copiedObjects) {
            if (!(node instanceof INode)) continue;
            this.addChildren((INode)node, nodesInHierarchy);
        }
        return nodesInHierarchy;
    }

    @Override
    protected boolean calculateEnabled() {
        List<Object> copiableObjects = this.editor.getSelectionCache().getSelectionModelForType(ICopyable.class);
        ISelection currentSelection = this.editor.getSelectionCache().getLastRawSelection();
        ArrayList<ICopyable> cuttableObjects = new ArrayList<ICopyable>();
        for (Object obj : copiableObjects) {
            ANode node;
            ANode parent;
            ICopyable copyableObject = (ICopyable)obj;
            if (!copyableObject.isCuttable(currentSelection)) continue;
            cuttableObjects.add(copyableObject);
            if (!(obj instanceof ANode) || !((parent = (node = (ANode)obj).getParent()) instanceof MStyleTemplate)) continue;
            return false;
        }
        return !cuttableObjects.isEmpty();
    }

    @Override
    protected Command createCommand() {
        List<Object> copiableObjects = this.editor.getSelectionCache().getSelectionModelForType(ICopyable.class);
        if (copiableObjects.isEmpty()) {
            return null;
        }
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        CutCommand cmd = new CutCommand();
        command.add(cmd);
        HashSet<INode> nestedNodes = this.getNotNestedNodes(copiableObjects);
        ISelection currentSelection = this.editor.getSelectionCache().getLastRawSelection();
        for (Object it : copiableObjects) {
            ICopyable copyable = (ICopyable)it;
            if (!copyable.isCuttable(currentSelection)) continue;
            cmd.addElement((ICopyable)it);
            if (!(it instanceof MGraphicElement)) continue;
            MGraphicElement node = (MGraphicElement)it;
            command.setReferenceNodeIfNull(node.getRoot());
            if (nestedNodes.contains(node)) continue;
            DeleteElementCommand deleteCommand = new DeleteElementCommand(node);
            command.add(deleteCommand);
        }
        return command;
    }
}

